/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.navigation;

import com.atlassian.jira.plugin.AbstractJiraModuleDescriptor;
import com.atlassian.jira.plugin.navigation.FooterDataProvider;
import com.atlassian.jira.plugin.navigation.FooterModuleDescriptor;
import com.atlassian.jira.plugin.navigation.PluggableFooter;
import com.atlassian.jira.plugin.util.ModuleDescriptorXMLUtils;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.module.ModuleFactory;
import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Element;

@ParametersAreNonnullByDefault
public class FooterModuleDescriptorImpl
extends AbstractJiraModuleDescriptor<PluggableFooter>
implements FooterModuleDescriptor {
    private static final String VIEW_TEMPLATE = "view";
    private static final String LINK_TEMPLATE = "link";
    private int order;

    public FooterModuleDescriptorImpl(JiraAuthenticationContext authenticationContext, ModuleFactory moduleFactory) {
        super(authenticationContext, moduleFactory);
    }

    @Override
    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.order = ModuleDescriptorXMLUtils.getOrder((Element)element);
    }

    @Override
    public void enabled() {
        super.enabled();
    }

    public int getOrder() {
        return this.order;
    }

    public String getFooterHtml(HttpServletRequest request, Map<String, ?> startingParams) {
        Map<String, Object> params = this.createVelocityParams(request, startingParams);
        String licenseLink = this.getHtml(LINK_TEMPLATE, params);
        params.put("licenseLink", licenseLink);
        return this.getHtml(VIEW_TEMPLATE, params);
    }

    @VisibleForTesting
    Map<String, Object> createVelocityParams(HttpServletRequest request, @Nullable Map<String, ?> startingParams) {
        HashMap<String, Object> params = startingParams != null ? new HashMap<String, Object>(startingParams) : new HashMap();
        params.put("string", new StringUtils());
        this.addFooterModel(request.getContextPath(), params);
        return params;
    }

    @VisibleForTesting
    void addFooterModel(@Nonnull String contextPath, @Nonnull Map<String, Object> params) {
        FooterDataProvider footerDataProvider = FooterDataProvider.getInstance(contextPath);
        footerDataProvider.addToMap(params);
    }
}

