/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webwork;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.extension.Startable;
import com.atlassian.jira.plugin.JiraPluginCacheResetEvent;
import com.atlassian.jira.plugin.webwork.WebworkModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.seraph.util.PathMapper;
import electric.xml.Document;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WebworkPluginSecurityServiceHelper
implements Startable {
    private static final String ROLES_REQUIRED_ATTR = "roles-required";
    private static final String extension = "jspa";
    @ClusterSafe
    private final Map<String, String> rolesMap = new ConcurrentHashMap<String, String>();
    private PathMapper actionMapper = new PathMapper();
    private final PluginAccessor pluginAccesor;
    private final EventPublisher eventPublisher;

    public WebworkPluginSecurityServiceHelper(PluginAccessor pluginAccesor, EventPublisher eventPublisher) {
        this.pluginAccesor = pluginAccesor;
        this.eventPublisher = eventPublisher;
    }

    @EventListener
    public void onJiraPluginCacheResetEvent(JiraPluginCacheResetEvent event) {
        if (event.hasAnyEventWithModuleDescriptorMatching(WebworkModuleDescriptor.class::isInstance)) {
            this.generatePathMaps();
        }
    }

    private void generatePathMaps() {
        this.actionMapper = new PathMapper();
        this.rolesMap.clear();
        List webworkModuleDescriptors = this.pluginAccesor.getEnabledModuleDescriptorsByClass(WebworkModuleDescriptor.class);
        for (WebworkModuleDescriptor webworkModuleDescriptor : webworkModuleDescriptors) {
            Document pluginDocument = webworkModuleDescriptor.getWebworkDocument();
            NodeList actions = pluginDocument.getElementsByTagName("action");
            String rootRolesRequired = this.overrideRoles(null, pluginDocument.getDocumentElement());
            for (int i = 0; i < actions.getLength(); ++i) {
                Element action = (Element)actions.item(i);
                String actionName = action.getAttribute("name");
                String actionAlias = action.getAttribute("alias");
                String actionRolesRequired = this.overrideRoles(rootRolesRequired, action);
                if (actionRolesRequired == null) continue;
                if (actionAlias != null) {
                    this.actionMapper.put(actionAlias, "/" + actionAlias + "." + extension);
                    this.rolesMap.put(actionAlias, actionRolesRequired);
                    this.actionMapper.put(actionAlias + "!*", "/" + actionAlias + "!*." + extension);
                    this.rolesMap.put(actionAlias + "!*", actionRolesRequired);
                }
                if (actionName == null) continue;
                this.actionMapper.put(actionName, "/" + actionName + "." + extension);
                this.rolesMap.put(actionName, actionRolesRequired);
                this.actionMapper.put(actionName + "!*", "/" + actionName + "!*." + extension);
                this.rolesMap.put(actionName + "!*", actionRolesRequired);
            }
        }
    }

    private String overrideRoles(String rolesRequired, Element action) {
        if (action.hasAttribute(ROLES_REQUIRED_ATTR)) {
            return action.getAttribute(ROLES_REQUIRED_ATTR);
        }
        return rolesRequired;
    }

    public Set<String> getRequiredRoles(HttpServletRequest request) {
        HashSet<String> requiredRoles = new HashSet<String>();
        String currentURL = request.getRequestURI();
        int lastSlash = currentURL.lastIndexOf(47);
        String targetURL = lastSlash > -1 ? currentURL.substring(lastSlash) : currentURL;
        String actionMatch = this.actionMapper.get(targetURL);
        if (actionMatch != null) {
            String rolesStr = this.rolesMap.get(actionMatch);
            StringTokenizer st = new StringTokenizer(rolesStr, ", ");
            while (st.hasMoreTokens()) {
                requiredRoles.add(st.nextToken());
            }
        }
        return Collections.unmodifiableSet(requiredRoles);
    }

    public void start() throws Exception {
        this.eventPublisher.register((Object)this);
        this.generatePathMaps();
    }
}

