/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.project.version;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.model.querydsl.QCustomField;
import com.atlassian.jira.model.querydsl.QCustomFieldValue;
import com.atlassian.jira.project.version.CustomFieldVersionTransformation;
import com.atlassian.jira.project.version.CustomFieldWithVersionUsage;
import com.atlassian.jira.project.version.DeleteVersionWithCustomFieldParameters;
import com.atlassian.jira.project.version.Version;
import com.atlassian.jira.project.version.VersionCollectionManipulators;
import com.atlassian.jira.util.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.sql.SQLQuery;
import io.atlassian.fugue.Option;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class VersionCustomFieldStore {
    private final QueryDslAccessor queryDslAccessor;
    private final Supplier<CustomFieldManager> customFieldManagerSupplier;
    private static final BooleanExpression IS_VERSION_PICKER = QCustomField.CUSTOM_FIELD.customfieldtypekey.eq((Object)"com.atlassian.jira.plugin.system.customfieldtypes:version").or((Predicate)QCustomField.CUSTOM_FIELD.customfieldtypekey.eq((Object)"com.atlassian.jira.plugin.system.customfieldtypes:multiversion"));

    public VersionCustomFieldStore(QueryDslAccessor queryDslAccessor) {
        this.queryDslAccessor = queryDslAccessor;
        this.customFieldManagerSupplier = Suppliers.memoize(ComponentAccessor::getCustomFieldManager);
    }

    @Nonnull
    public List<CustomFieldVersionTransformation> createValueReplacers(Version deletedVersion, List<DeleteVersionWithCustomFieldParameters.CustomFieldReplacement> customFieldReplacementList) {
        Collection<CustomField> customFieldsTypesUsing = this.getCustomFieldsTypesUsing(deletedVersion);
        Map<Long, Version> customFieldIdToTargetVersion = customFieldReplacementList.stream().filter(replacement -> replacement.getMoveTo().isPresent()).collect(Collectors.toMap(DeleteVersionWithCustomFieldParameters.CustomFieldReplacement::getCustomFieldId, replacement -> (Version)replacement.getMoveTo().get()));
        return customFieldsTypesUsing.stream().map(customField -> {
            Option replacements = Option.option(customFieldIdToTargetVersion.get(customField.getIdAsLong()));
            return this.getCustomFieldTransformer(deletedVersion, (CustomField)customField, (Option<Version>)replacements);
        }).collect(Collectors.toList());
    }

    @Nonnull
    public List<CustomFieldVersionTransformation> createValueReplacers(Version deletedVersion, Option<Version> targetVersion) {
        Collection<CustomField> customFieldsTypesUsing = this.getCustomFieldsTypesUsing(deletedVersion);
        return customFieldsTypesUsing.stream().map(customField -> this.getCustomFieldTransformer(deletedVersion, (CustomField)customField, targetVersion)).collect(Collectors.toList());
    }

    private CustomFieldVersionTransformation getCustomFieldTransformer(Version deletedVersion, CustomField customField, Option<Version> replacement) {
        return new CustomFieldVersionTransformation(customField, (Function<Collection<Version>, Collection<Version>>)((Function)replacement.fold(() -> VersionCollectionManipulators.versionRemover(deletedVersion), versionReplacement -> VersionCollectionManipulators.versionReplacer(deletedVersion, versionReplacement))));
    }

    @Nonnull
    public Collection<? extends CustomFieldWithVersionUsage> getCustomFieldsUsing(Version version) {
        Preconditions.checkNotNull((Object)version.getId());
        double versionId = version.getId().doubleValue();
        return this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select((Expression)Projections.constructor(CustomFieldUsageImpl.class, (Expression[])new Expression[]{QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield, QCustomField.CUSTOM_FIELD.name, QCustomFieldValue.CUSTOM_FIELD_VALUE.issue.countDistinct()})).from((SubQueryExpression)((SQLQuery)connection.newSqlQuery().select(new Expression[]{QCustomField.CUSTOM_FIELD.id, QCustomField.CUSTOM_FIELD.name}).from((Expression)QCustomField.CUSTOM_FIELD)).where((Predicate)IS_VERSION_PICKER), (Path)QCustomField.CUSTOM_FIELD)).leftJoin((SubQueryExpression)((SQLQuery)connection.newSqlQuery().select(new Expression[]{QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield, QCustomFieldValue.CUSTOM_FIELD_VALUE.issue}).from((Expression)QCustomFieldValue.CUSTOM_FIELD_VALUE)).where((Predicate)QCustomFieldValue.CUSTOM_FIELD_VALUE.numbervalue.eq((Object)versionId)), (Path)QCustomFieldValue.CUSTOM_FIELD_VALUE)).on((Predicate)QCustomField.CUSTOM_FIELD.id.eq(QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield))).groupBy(new Expression[]{QCustomField.CUSTOM_FIELD.name, QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield})).fetch()).stream().filter(customFieldUsage -> customFieldUsage.getIssueCountWithVersionInCustomField() > 0L).collect(Collectors.toList());
    }

    @Nonnull
    public Collection<CustomField> getCustomFieldsTypesUsing(Version version) {
        Preconditions.checkNotNull((Object)version.getId());
        double versionId = version.getId().doubleValue();
        List customFieldIds = this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select(QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield).from((SubQueryExpression)((SQLQuery)connection.newSqlQuery().select(QCustomField.CUSTOM_FIELD.id).from((Expression)QCustomField.CUSTOM_FIELD)).where((Predicate)IS_VERSION_PICKER), (Path)QCustomField.CUSTOM_FIELD)).leftJoin((SubQueryExpression)((SQLQuery)connection.newSqlQuery().select(QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield).from((Expression)QCustomFieldValue.CUSTOM_FIELD_VALUE)).where((Predicate)QCustomFieldValue.CUSTOM_FIELD_VALUE.numbervalue.eq((Object)versionId)), (Path)QCustomFieldValue.CUSTOM_FIELD_VALUE)).on((Predicate)QCustomField.CUSTOM_FIELD.id.eq(QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield))).distinct()).fetch());
        CustomFieldManager customFieldManager = (CustomFieldManager)this.customFieldManagerSupplier.get();
        return customFieldIds.stream().filter(Objects::nonNull).map(arg_0 -> ((CustomFieldManager)customFieldManager).getCustomFieldObject(arg_0)).collect(Collectors.toList());
    }

    public List<Long> getIssueIdsWithCustomFieldsFor(@Nonnull Version version) {
        Preconditions.checkNotNull((Object)version.getId());
        double versionId = version.getId().doubleValue();
        return this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select(QCustomFieldValue.CUSTOM_FIELD_VALUE.issue).from((SubQueryExpression)((SQLQuery)connection.newSqlQuery().select(QCustomField.CUSTOM_FIELD.id).from((Expression)QCustomField.CUSTOM_FIELD)).where((Predicate)IS_VERSION_PICKER), (Path)QCustomField.CUSTOM_FIELD)).leftJoin((SubQueryExpression)((SQLQuery)connection.newSqlQuery().select(new Expression[]{QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield, QCustomFieldValue.CUSTOM_FIELD_VALUE.issue}).from((Expression)QCustomFieldValue.CUSTOM_FIELD_VALUE)).where((Predicate)QCustomFieldValue.CUSTOM_FIELD_VALUE.numbervalue.eq((Object)versionId)), (Path)QCustomFieldValue.CUSTOM_FIELD_VALUE)).on((Predicate)QCustomField.CUSTOM_FIELD.id.eq(QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield))).distinct()).fetch()).stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    public long getCustomFieldIssuesCount(Version version) {
        Preconditions.checkNotNull((Object)version.getId());
        double versionId = version.getId().doubleValue();
        return this.queryDslAccessor.executeQuery(connection -> (Long)((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select((Expression)QCustomFieldValue.CUSTOM_FIELD_VALUE.issue.countDistinct()).from((SubQueryExpression)((SQLQuery)connection.newSqlQuery().select(new Expression[]{QCustomField.CUSTOM_FIELD.id, QCustomField.CUSTOM_FIELD.name}).from((Expression)QCustomField.CUSTOM_FIELD)).where((Predicate)IS_VERSION_PICKER), (Path)QCustomField.CUSTOM_FIELD)).leftJoin((SubQueryExpression)((SQLQuery)connection.newSqlQuery().select(new Expression[]{QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield, QCustomFieldValue.CUSTOM_FIELD_VALUE.issue}).from((Expression)QCustomFieldValue.CUSTOM_FIELD_VALUE)).where((Predicate)QCustomFieldValue.CUSTOM_FIELD_VALUE.numbervalue.eq((Object)versionId)), (Path)QCustomFieldValue.CUSTOM_FIELD_VALUE)).on((Predicate)QCustomField.CUSTOM_FIELD.id.eq(QCustomFieldValue.CUSTOM_FIELD_VALUE.customfield))).fetchOne());
    }

    public static class CustomFieldUsageImpl
    implements CustomFieldWithVersionUsage {
        private final long customFieldId;
        private final String fieldName;
        private final long fieldCount;

        public CustomFieldUsageImpl(long customFieldId, String fieldName, long fieldCount) {
            this.fieldName = fieldName;
            this.fieldCount = fieldCount;
            this.customFieldId = customFieldId;
        }

        public long getCustomFieldId() {
            return this.customFieldId;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public long getIssueCountWithVersionInCustomField() {
            return this.fieldCount;
        }
    }
}

