/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.security.auth.rememberme;

import com.atlassian.core.util.Clock;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.util.RealClock;
import com.atlassian.jira.util.collect.MapBuilder;
import com.atlassian.seraph.service.rememberme.DefaultRememberMeToken;
import com.atlassian.seraph.service.rememberme.RememberMeToken;
import com.atlassian.seraph.spi.rememberme.RememberMeConfiguration;
import com.atlassian.seraph.spi.rememberme.RememberMeTokenDao;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.ofbiz.core.entity.GenericValue;

public class JiraRememberMeTokenDao
implements RememberMeTokenDao {
    public static final String TABLE = "RememberMeToken";
    private final OfBizDelegator delegator;
    private final RememberMeConfiguration rememberMeConfiguration;
    private final Clock clock;
    private final UserKeyService userKeyService;

    public JiraRememberMeTokenDao(OfBizDelegator delegator, RememberMeConfiguration rememberMeConfiguration) {
        this(delegator, rememberMeConfiguration, RealClock.getInstance(), ComponentAccessor.getUserKeyService());
    }

    public JiraRememberMeTokenDao(OfBizDelegator delegator, RememberMeConfiguration rememberMeConfiguration, Clock clock, UserKeyService userKeyService) {
        this.delegator = delegator;
        this.rememberMeConfiguration = rememberMeConfiguration;
        this.clock = clock;
        this.userKeyService = userKeyService;
    }

    public long countAll() {
        return this.delegator.getCount(TABLE);
    }

    public RememberMeToken findById(Long tokenId) {
        return this.releaseToken(this.delegator.findByPrimaryKey(TABLE, tokenId));
    }

    public List<RememberMeToken> findForUserName(String userName) {
        String userKey = this.userKeyService.getKeyForUsername(userName);
        if (userKey == null) {
            return Collections.emptyList();
        }
        Map andMap = MapBuilder.newBuilder((Object)"username", (Object)userKey).toMap();
        List gvs = this.delegator.findByAnd(TABLE, andMap);
        ArrayList<RememberMeToken> tokens = new ArrayList<RememberMeToken>(gvs.size());
        for (GenericValue gv : gvs) {
            RememberMeToken token = this.releaseToken(gv);
            if (token == null) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public RememberMeToken save(RememberMeToken token) {
        Timestamp now = new Timestamp(this.clock.getCurrentDate().getTime());
        Map values = MapBuilder.newBuilder((Object)"token", (Object)token.getRandomString()).add((Object)"username", (Object)this.userKeyService.getKeyForUsername(token.getUserName())).add((Object)"created", (Object)now).toMap();
        GenericValue gv = this.delegator.createValue(TABLE, values);
        return this.releaseToken(gv);
    }

    public void remove(Long tokenId) {
        GenericValue gv = this.delegator.findByPrimaryKey(TABLE, tokenId);
        if (gv != null) {
            this.delegator.removeValue(gv);
        }
    }

    public void removeAllForUser(String username) {
        Map andMap = MapBuilder.newBuilder((Object)"username", (Object)this.userKeyService.getKeyForUsername(username)).toMap();
        this.delegator.removeByAnd(TABLE, andMap);
    }

    public void removeAll() {
        this.delegator.removeByAnd(TABLE, Collections.emptyMap());
    }

    private RememberMeToken releaseToken(GenericValue gv) {
        if (gv != null) {
            if (!this.hasExpired(gv)) {
                long createdTime = gv.getTimestamp("created").getTime();
                return DefaultRememberMeToken.builder((Long)gv.getLong("id"), (String)gv.getString("token")).setUserName(this.userKeyService.getUsernameForKey(gv.getString("username"))).setCreatedTime(createdTime).build();
            }
            this.delegator.removeValue(gv);
        }
        return null;
    }

    private boolean hasExpired(GenericValue gv) {
        long now;
        long maxAgeMS = this.rememberMeConfiguration.getCookieMaxAgeInSeconds() * 1000;
        Timestamp createdTS = gv.getTimestamp("created");
        if (createdTS == null) {
            return true;
        }
        long howOld = createdTS.getTime() + maxAgeMS;
        return howOld < (now = this.clock.getCurrentDate().getTime());
    }

    public static final class Columns {
        public static final String ID = "id";
        public static final String CREATED = "created";
        public static final String TOKEN = "token";
        public static final String USERKEY = "username";
    }
}

