/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servermetrics;

import com.atlassian.jira.servermetrics.NestedRequestKeyResolver;
import com.atlassian.jira.servermetrics.RequestKeyResolver;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;

public class MultiThreadedRequestKeyResolver {
    private final RequestKeyResolver requestKeyResolver;
    private final ThreadLocal<NestedRequestKeyResolver> perThreadResolver;

    public MultiThreadedRequestKeyResolver(RequestKeyResolver requestKeyResolver) {
        this.requestKeyResolver = requestKeyResolver;
        this.perThreadResolver = ThreadLocal.withInitial(() -> new NestedRequestKeyResolver(this.requestKeyResolver));
    }

    public void requestStarted(HttpServletRequest httpServletRequest) {
        this.perThreadResolver.get().requestStarted(httpServletRequest);
    }

    public Optional<String> requestFinished(HttpServletRequest httpServletRequest) {
        return this.perThreadResolver.get().requestFinished(httpServletRequest);
    }
}

