/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servermetrics;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.servermetrics.CheckpointTiming;
import com.atlassian.jira.servermetrics.ServerMetricsDetailCollector;
import com.atlassian.jira.servermetrics.TimingInformation;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@NotThreadSafe
class RequestMetricsCollector
implements ServerMetricsDetailCollector {
    private List<CheckpointTiming> timingEventList = Lists.newArrayList();
    private Map<String, Duration> activities = Maps.newHashMap();
    private final Set<String> visitedCheckpoints = Sets.newHashSet();
    private final Stopwatch stopwatch;
    private final Duration userTimeStart;
    private final Duration cpuTimeStart;
    private final Duration garbageCollectionTimeStart;
    private final long garbageCollectionCountStart;

    public static RequestMetricsCollector started(Stopwatch stopwatch) {
        return new RequestMetricsCollector(stopwatch.start(), RequestMetricsCollector.getCurrentThreadUserDuration(), RequestMetricsCollector.getCurrentThreadCpuDuration(), RequestMetricsCollector.getGarbageCollectionDuration(), RequestMetricsCollector.getGarbageCollectionCount());
    }

    private RequestMetricsCollector(Stopwatch stopwatch, Duration userTimeStart, Duration cpuTimeStart, Duration garbageCollectionTimeStart, long garbageCollectionCountStart) {
        this.stopwatch = stopwatch;
        this.userTimeStart = userTimeStart;
        this.cpuTimeStart = cpuTimeStart;
        this.garbageCollectionTimeStart = garbageCollectionTimeStart;
        this.garbageCollectionCountStart = garbageCollectionCountStart;
    }

    public void checkpointReached(String checkpointName) {
        this.visitedCheckpoints.add(checkpointName);
        this.timingEventList.add(new CheckpointTiming(checkpointName, Duration.ofNanos(this.stopwatch.elapsed(TimeUnit.NANOSECONDS))));
    }

    public void checkpointReachedOnce(String checkpointName) {
        if (!this.visitedCheckpoints.contains(checkpointName)) {
            this.checkpointReached(checkpointName);
        }
    }

    public void checkpointReachedOverride(String checkpointName) {
        if (this.visitedCheckpoints.contains(checkpointName)) {
            this.timingEventList = (List)this.timingEventList.stream().filter(checkpointOccurence -> !checkpointOccurence.checkpointName.equals(checkpointName)).collect(CollectorsUtil.toNewArrayListWithCapacity((int)this.timingEventList.size()));
        }
        this.checkpointReached(checkpointName);
    }

    public void addTimeSpentInActivity(String activityName, Duration duration) {
        this.activities.compute(activityName, (name, exisitingData) -> exisitingData == null ? duration : duration.plus((Duration)exisitingData));
    }

    public void setTimeSpentInActivity(String activityName, Duration duration) {
        this.activities.put(activityName, duration);
    }

    @Nonnull
    public TimingInformation getCurrentTiming() {
        ImmutableList activityTiming = (ImmutableList)this.activities.entrySet().stream().map(stringDurationEntry -> new CheckpointTiming((String)stringDurationEntry.getKey(), (Duration)stringDurationEntry.getValue())).collect(CollectorsUtil.toImmutableListWithCapacity((int)this.activities.size()));
        return new TimingInformation((List<CheckpointTiming>)ImmutableList.copyOf(this.timingEventList), (List<CheckpointTiming>)activityTiming, Duration.ofNanos(this.stopwatch.elapsed(TimeUnit.NANOSECONDS)), RequestMetricsCollector.getCurrentThreadUserDuration().minus(this.userTimeStart), RequestMetricsCollector.getCurrentThreadCpuDuration().minus(this.cpuTimeStart), RequestMetricsCollector.getGarbageCollectionDuration().minus(this.garbageCollectionTimeStart), RequestMetricsCollector.getGarbageCollectionCount() - this.garbageCollectionCountStart);
    }

    private static long getGarbageCollectionCount() {
        return ManagementFactory.getGarbageCollectorMXBeans().stream().map(GarbageCollectorMXBean::getCollectionCount).reduce(Long::sum).orElse(0L);
    }

    @Nonnull
    private static Duration getGarbageCollectionDuration() {
        return ManagementFactory.getGarbageCollectorMXBeans().stream().map(GarbageCollectorMXBean::getCollectionTime).reduce(Long::sum).map(Duration::ofMillis).orElse(Duration.ZERO);
    }

    @Nonnull
    private static Duration getCurrentThreadCpuDuration() {
        return Duration.ofNanos(ManagementFactory.getThreadMXBean().getCurrentThreadCpuTime());
    }

    @Nonnull
    private static Duration getCurrentThreadUserDuration() {
        return Duration.ofNanos(ManagementFactory.getThreadMXBean().getCurrentThreadUserTime());
    }
}

