/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.servlet;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.johnson.DefaultJohnsonProvider;
import com.atlassian.jira.util.johnson.JiraJohnsonContainer;
import com.atlassian.jira.util.johnson.JohnsonEventType;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.util.system.status.ApplicationState;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ApplicationStatusServlet
extends HttpServlet {
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ApplicationStateAndHttpStatus state = this.getApplicationState();
        resp.setStatus(state.httpStatus);
        resp.setContentType("application/json");
        resp.getWriter().append("{\"state\":\"").append(state.applicationState.name()).append("\"}");
    }

    private ApplicationStateAndHttpStatus getApplicationState() {
        if (ApplicationStatusServlet.anyJohnsonEventsPreventStartup()) {
            if (ApplicationStatusServlet.onlyEventIsIndexing()) {
                return new ApplicationStateAndHttpStatus(ApplicationState.MAINTENANCE, 503);
            }
            return new ApplicationStateAndHttpStatus(ApplicationState.ERROR, 500);
        }
        if (!this.hasStarted()) {
            return new ApplicationStateAndHttpStatus(ApplicationState.STARTING, 200);
        }
        if (ApplicationStatusServlet.isFirstRun()) {
            return new ApplicationStateAndHttpStatus(ApplicationState.FIRST_RUN, 200);
        }
        if (ApplicationStatusServlet.anyJohnsonEventsExist()) {
            return new ApplicationStateAndHttpStatus(ApplicationState.RUNNING, 200);
        }
        return new ApplicationStateAndHttpStatus(ApplicationState.RUNNING, 200);
    }

    private static boolean onlyEventIsIndexing() {
        return ApplicationStatusServlet.getJohnsonContainer().getEventsThatPreventStartup().stream().allMatch(e -> e.getKey().equals((Object)JohnsonEventType.REINDEX.eventType()));
    }

    private static boolean anyJohnsonEventsPreventStartup() {
        return ApplicationStatusServlet.getJohnsonContainer().hasEventThatPreventsStartup();
    }

    private static boolean anyJohnsonEventsExist() {
        return !ApplicationStatusServlet.getJohnsonContainer().getEvents().isEmpty();
    }

    private boolean hasStarted() {
        ComponentManager.State state = this.getState();
        return state.isComponentsRegistered() && state.isContainerInitialised() && state.isPluginSystemStarted() && state.isStarted();
    }

    @VisibleForTesting
    protected ComponentManager.State getState() {
        return ComponentManager.getInstance().getState();
    }

    private static JiraJohnsonContainer getJohnsonContainer() {
        return ComponentAccessor.getComponentSafely(JohnsonProvider.class).orElseGet(DefaultJohnsonProvider::new).getContainer();
    }

    private static boolean isFirstRun() {
        return !JiraUtils.isSetUp();
    }

    private static class ApplicationStateAndHttpStatus {
        final ApplicationState applicationState;
        final int httpStatus;

        public ApplicationStateAndHttpStatus(ApplicationState applicationState, int httpStatus) {
            this.applicationState = applicationState;
            this.httpStatus = httpStatus;
        }
    }
}

