/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.index;

import com.atlassian.jira.sharing.SharedEntity;
import com.atlassian.jira.sharing.index.IsSharedFieldFactory;
import com.atlassian.jira.sharing.index.ShareTypePermissionsFieldFactory;
import com.atlassian.jira.sharing.index.SharedEntityDocumentFactory;
import com.atlassian.jira.sharing.index.SharedEntityFieldFactory;
import com.atlassian.jira.sharing.type.ShareTypeFactory;
import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;

class DefaultDocumentFactory
implements SharedEntityDocumentFactory {
    private final List<SharedEntityFieldFactory> fieldBuilders;

    static DefaultDocumentFactory create(ShareTypeFactory shareTypeFactory) {
        return new DefaultDocumentFactory((List<SharedEntityFieldFactory>)ImmutableList.builder().addAll(SharedEntityFieldFactory.Default.BUILDERS).add((Object)new IsSharedFieldFactory()).add((Object)new ShareTypePermissionsFieldFactory(shareTypeFactory)).build());
    }

    private DefaultDocumentFactory(List<SharedEntityFieldFactory> fieldBuilders) {
        this.fieldBuilders = fieldBuilders;
    }

    @Override
    public Document create(SharedEntity entity) {
        LinkedList<Field> fields = new LinkedList<Field>();
        for (SharedEntityFieldFactory builder : this.fieldBuilders) {
            fields.addAll(builder.getField(entity));
        }
        Document document = new Document();
        for (Field field : fields) {
            document.add((IndexableField)field);
        }
        return document;
    }
}

