/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.AbstractShareTypeValidator;
import com.atlassian.jira.sharing.type.AuthenticatedUserShareType;
import com.atlassian.jira.sharing.type.ShareTypeValidator;
import com.atlassian.jira.util.dbc.Assertions;

public class AuthenticatedUserShareTypeValidator
extends AbstractShareTypeValidator
implements ShareTypeValidator {
    private final PermissionManager permissionManager;

    public AuthenticatedUserShareTypeValidator(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public boolean checkSharePermission(JiraServiceContext ctx, SharePermission permission) {
        boolean hasPermission;
        Assertions.notNull((String)"ctx", (Object)ctx);
        Assertions.notNull((String)"permission", (Object)permission);
        Assertions.equals((String)"permission-type", (Object)AuthenticatedUserShareType.TYPE, (Object)permission.getType());
        if (!this.validateUsageContext(permission)) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("common.sharing.exception.invalid.usage.context.authenticated"));
        }
        if (!(hasPermission = this.permissionManager.hasPermission(22, ctx.getLoggedInUser()))) {
            ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("common.sharing.exception.no.share.permission"));
        }
        return !ctx.getErrorCollection().hasAnyErrors();
    }

    public boolean checkSearchParameter(JiraServiceContext ctx, ShareTypeSearchParameter searchParameter) {
        Assertions.notNull((String)"ctx", (Object)ctx);
        Assertions.notNull((String)"searchParameter", (Object)searchParameter);
        Assertions.equals((String)"permission-type", (Object)AuthenticatedUserShareType.TYPE, (Object)searchParameter.getType());
        return true;
    }
}

