/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.sharing.type;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.bc.JiraServiceContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.sharing.SharePermission;
import com.atlassian.jira.sharing.search.GroupShareTypeSearchParameter;
import com.atlassian.jira.sharing.search.ShareTypeSearchParameter;
import com.atlassian.jira.sharing.type.AbstractShareTypeValidator;
import com.atlassian.jira.sharing.type.GroupShareType;
import com.atlassian.jira.sharing.type.ShareTypeValidator;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.dbc.Assertions;
import org.apache.commons.lang3.StringUtils;

public class GroupShareTypeValidator
extends AbstractShareTypeValidator
implements ShareTypeValidator {
    private final PermissionManager permissionManager;
    private final GroupManager groupManager;

    public GroupShareTypeValidator(PermissionManager permissionManager, GroupManager groupManager) {
        this.permissionManager = permissionManager;
        this.groupManager = groupManager;
    }

    public boolean checkSharePermission(JiraServiceContext ctx, SharePermission permission) {
        Assertions.notNull((String)"ctx", (Object)ctx);
        Assertions.notNull((String)"permission", (Object)permission);
        ApplicationUser user = (ApplicationUser)Assertions.notNull((String)"ctx.user", (Object)ctx.getLoggedInApplicationUser());
        Assertions.equals((String)GroupShareType.TYPE.toString(), (Object)GroupShareType.TYPE, (Object)permission.getType());
        boolean hasPermission = this.permissionManager.hasPermission(22, user);
        if (!hasPermission) {
            ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.no.share.permission"));
        } else if (StringUtils.isBlank((CharSequence)permission.getParam1())) {
            String groupName = permission.getParam1() == null ? "" : permission.getParam1();
            ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.group.not.valid", groupName));
        } else {
            Group group = this.getGroup(permission.getParam1());
            if (group == null) {
                ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.group.does.not.exist", permission.getParam1()));
            } else if (!this.groupManager.isUserInGroup(user, group)) {
                if (!this.validateUsageContext(permission)) {
                    ctx.getErrorCollection().addErrorMessage(ctx.getI18nBean().getText("common.sharing.exception.invalid.usage.context.group", permission.getParam1()));
                }
                String userName = user.getDisplayName();
                ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.not.in.group", permission.getParam1()));
                ctx.getErrorCollection().addError("shares_delegated", ctx.getI18nBean().getText("common.sharing.exception.delegated.user.not.in.group", userName, permission.getParam1()));
            }
        }
        return !ctx.getErrorCollection().hasAnyErrors();
    }

    public boolean checkSearchParameter(JiraServiceContext ctx, ShareTypeSearchParameter searchParameter) {
        Assertions.notNull((String)"ctx", (Object)ctx);
        Assertions.notNull((String)"searchParameter", (Object)searchParameter);
        Assertions.equals((String)GroupShareType.TYPE.toString(), (Object)GroupShareType.TYPE, (Object)searchParameter.getType());
        ApplicationUser user = ctx.getLoggedInApplicationUser();
        if (user == null) {
            ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.searching.exception.anonymous.group.search"));
        } else {
            GroupShareTypeSearchParameter groupShareTypeSearchParameter = (GroupShareTypeSearchParameter)searchParameter;
            String groupName = groupShareTypeSearchParameter.getGroupName();
            if (StringUtils.isNotBlank((CharSequence)groupName)) {
                Group group = this.getGroup(groupName);
                if (group == null) {
                    ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.exception.group.does.not.exist", groupName));
                } else if (!this.groupManager.isUserInGroup(user, group)) {
                    ctx.getErrorCollection().addError("shares", ctx.getI18nBean().getText("common.sharing.searching.exception.not.in.group", groupName));
                    ctx.getErrorCollection().addError("shares_delegated", ctx.getI18nBean().getText("common.sharing.exception.delegated.user.not.in.group", user.getDisplayName(), groupName));
                }
            }
        }
        return !ctx.getErrorCollection().hasAnyErrors();
    }

    Group getGroup(String groupName) {
        return this.groupManager.getGroup(groupName);
    }
}

