/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.soy;

import com.atlassian.jira.help.HelpUrl;
import com.atlassian.jira.help.HelpUrls;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringEscapeUtils;

public abstract class AbstractHelpFunction
implements SoyServerFunction<String>,
SoyClientFunction {
    private static final ImmutableSet<Integer> ARGUMENTS_SIZE = ImmutableSet.of((Object)1);
    private static final Pattern SOY_STRING_PATTERN = Pattern.compile("^'(.*)'$");
    final String MSG_INVALID_ARGS = "Wrong number of arguments (1 expected)";
    private HelpUrls helpUrls;

    public AbstractHelpFunction(HelpUrls helpUrls) {
        this.helpUrls = (HelpUrls)Assertions.notNull((String)"helpUrls", (Object)helpUrls);
    }

    @Nonnull
    abstract String getHelpValue(HelpUrl var1);

    public JsExpression generate(JsExpression ... args) {
        Assertions.is((String)"Wrong number of arguments (1 expected)", (args.length == 1 ? 1 : 0) != 0);
        Matcher matcher = SOY_STRING_PATTERN.matcher(args[0].getText());
        Assertions.is((String)"The help key should be a string literal", (boolean)matcher.matches());
        String helpUrlKey = matcher.group(1);
        return new JsExpression('\"' + StringEscapeUtils.escapeEcmaScript((String)this.getDisplayValueForHelpUrl(helpUrlKey)) + '\"');
    }

    public String apply(Object ... args) {
        Assertions.is((String)"Wrong number of arguments (1 expected)", (args.length == 1 ? 1 : 0) != 0);
        Assertions.is((String)"The help key should be a String", (boolean)(args[0] instanceof String));
        String helpUrlKey = (String)args[0];
        return this.getDisplayValueForHelpUrl(helpUrlKey);
    }

    @Nonnull
    private String getDisplayValueForHelpUrl(@Nonnull String key) {
        return this.getHelpValue(this.getHelpUrl(key));
    }

    @Nonnull
    private HelpUrl getHelpUrl(@Nonnull String key) {
        return this.helpUrls.getUrl(key);
    }

    public Set<Integer> validArgSizes() {
        return ARGUMENTS_SIZE;
    }
}

