/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.warmer.JiraWarmer;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheWarmerLauncher {
    private static final Logger log = LoggerFactory.getLogger(CacheWarmerLauncher.class);
    private static final String CACHE_WARMER_SYNC_SYSPROP = "cache.warmer.sync";
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)CacheWarmerLauncher.class.getName());
    private final JiraProperties jiraProperties;

    CacheWarmerLauncher(JiraProperties jiraProperties) {
        this.jiraProperties = Objects.requireNonNull(jiraProperties);
    }

    public void start() {
        if (this.jiraProperties.getBoolean(CACHE_WARMER_SYNC_SYSPROP).booleanValue()) {
            this.runWarmersInParallel();
        } else {
            SchedulerService schedulerService = (SchedulerService)ComponentAccessor.getComponent(SchedulerService.class);
            schedulerService.registerJobRunner(JOB_RUNNER_KEY, jobRunnerRequest -> {
                this.runWarmersInParallel();
                return JobRunnerResponse.success();
            });
            JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.runOnce(null));
            try {
                schedulerService.scheduleJobWithGeneratedId(jobConfig);
            }
            catch (SchedulerServiceException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void runWarmersInParallel() {
        List<JiraWarmer> warmers = ComponentManager.getInstance().getComponentsOfType(JiraWarmer.class);
        log.info("Warming up {} caches.", (Object)warmers.size());
        long startTime = System.currentTimeMillis();
        warmers.parallelStream().forEach(Runnable::run);
        long totalTime = System.currentTimeMillis() - startTime;
        log.info("Warmed cache(s) in {} ms.", (Object)totalTime);
    }
}

