/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.cluster.ClusterServicesManager;
import com.atlassian.jira.cluster.monitoring.ClusterMonitoringBeansRegistrar;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.FeatureManager;
import com.google.common.annotations.VisibleForTesting;
import org.apache.log4j.Logger;

public class ClusteringLauncher {
    private static final Logger log = Logger.getLogger(ClusteringLauncher.class);
    private ClusterMonitoringBeansRegistrar clusterMonitoringBeansRegistrar;
    private boolean clusterMonitoringStarted;

    ClusteringLauncher() {
        this(new ClusterMonitoringBeansRegistrar());
    }

    @VisibleForTesting
    ClusteringLauncher(ClusterMonitoringBeansRegistrar clusterMonitoringBeansRegistrar) {
        this.clusterMonitoringBeansRegistrar = clusterMonitoringBeansRegistrar;
    }

    public void start() {
        ClusterManager clusterManager = (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class);
        if (clusterManager.isClustered()) {
            log.info((Object)"Checking local index on node start");
            clusterManager.checkIndex();
            FeatureManager featureManager = (FeatureManager)ComponentAccessor.getComponent(FeatureManager.class);
            if (featureManager.isEnabled("jira.zdu.jmx-monitoring")) {
                this.clusterMonitoringBeansRegistrar.registerClusterMonitoringMBeans();
                this.clusterMonitoringStarted = true;
            }
        }
    }

    public void stop() {
        ClusterManager clusterManager = (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class);
        if (clusterManager.isClustered()) {
            ClusterServicesManager clusterServicesManager = (ClusterServicesManager)ComponentAccessor.getComponent(ClusterServicesManager.class);
            clusterServicesManager.stopServices();
            if (this.clusterMonitoringStarted) {
                this.clusterMonitoringBeansRegistrar.unregisterClusterMonitorMBeans();
                this.clusterMonitoringStarted = false;
            }
        }
    }
}

