/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.startup;

import com.atlassian.jira.cluster.ClusterManager;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlushStaleClusterTasksLauncher {
    private static final Logger log = LoggerFactory.getLogger(FlushStaleClusterTasksLauncher.class);
    private ClusterManager clusterManager;
    private TaskManager taskManager;

    public void start() {
        this.clusterManager = (ClusterManager)ComponentAccessor.getComponent(ClusterManager.class);
        this.taskManager = (TaskManager)ComponentAccessor.getComponent(TaskManager.class);
        this.taskManager.getLiveTasks().forEach(this::removeTaskIfStale);
    }

    private void removeTaskIfStale(@Nonnull TaskDescriptor<?> activeTask) {
        if (!Objects.equals(activeTask.getNodeId(), this.clusterManager.getNodeId())) {
            log.debug("Skipping '{}' task '{}', executing on {}", new Object[]{activeTask.getDescription(), activeTask.getTaskId(), activeTask.getNodeId()});
            return;
        }
        if (!activeTask.isSelfRecovering()) {
            log.warn("Removing stale '{}' task '{}' assigned to this node. Removing stale task might cause some side-effects, e.g. in case of FullReindexing index might be inconsistent", (Object)activeTask.getDescription(), (Object)activeTask.getTaskId());
            this.taskManager.removeTask(activeTask.getTaskId());
        } else {
            log.debug("Skipping self recovering '{}' task '{}'", (Object)activeTask.getDescription(), (Object)activeTask.getTaskId());
        }
    }
}

