/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.core.ofbiz.CoreFactory;
import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.config.database.DatabaseConfig;
import com.atlassian.jira.config.database.DatabaseConfigurationManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.entity.EntityEngine;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.index.request.ReindexRequestService;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.upgrade.UpgradeTask;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.upgrade.api.UpgradeContext;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericDelegator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericHelper;
import org.ofbiz.core.entity.config.EntityConfigUtil;
import org.ofbiz.core.entity.jdbc.DatabaseUtil;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseType;
import org.ofbiz.core.entity.jdbc.dbtype.DatabaseTypeFactory;

public abstract class AbstractUpgradeTask
implements UpgradeTask,
com.atlassian.upgrade.spi.UpgradeTask {
    private final List<String> errors = new ArrayList<String>();

    protected static OfBizDelegator getOfBizDelegator() {
        return ComponentAccessor.getOfBizDelegator();
    }

    protected static EntityEngine getEntityEngine() {
        return (EntityEngine)ComponentAccessor.getComponent(EntityEngine.class);
    }

    static String ensureTablePrefixed(String tableName, String schemaName) {
        String prefix;
        if (StringUtils.isNotBlank((CharSequence)schemaName) && !tableName.startsWith(prefix = schemaName + '.')) {
            return prefix + tableName;
        }
        return tableName;
    }

    public void runUpgrade(UpgradeContext upgradeContext) {
        try {
            boolean setupMode = upgradeContext.getTrigger() == UpgradeContext.UpgradeTrigger.PROVISIONING;
            this.doUpgrade(setupMode);
        }
        catch (Exception e) {
            throw new RuntimeException("Error running original upgrade task", e);
        }
    }

    @Override
    @Nullable
    public Integer dependsUpon() {
        return null;
    }

    @Deprecated
    protected GenericDelegator getDelegator() {
        return CoreFactory.getGenericDelegator();
    }

    protected ApplicationProperties getApplicationProperties() {
        return ComponentAccessor.getApplicationProperties();
    }

    protected ReindexRequestService getReindexRequestService() {
        return (ReindexRequestService)ComponentAccessor.getComponent(ReindexRequestService.class);
    }

    protected void addError(String error) {
        this.errors.add(error);
    }

    public void addErrors(String prefix, Collection<String> errors) {
        errors.forEach(error -> this.addError(prefix + error));
    }

    public void addErrors(Collection<String> errors) {
        this.addErrors("", errors);
    }

    @Override
    public Collection<String> getErrors() {
        return this.errors;
    }

    protected I18nHelper getI18nBean() {
        return ComponentAccessor.getJiraAuthenticationContext().getI18nHelper();
    }

    protected DatabaseUtil getDatabaseUtil() {
        try {
            GenericHelper helper = this.getDelegator().getEntityHelper("User");
            return new DatabaseUtil(helper.getHelperName());
        }
        catch (GenericEntityException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected Connection getDatabaseConnection() {
        try {
            DatabaseUtil utils = this.getDatabaseUtil();
            return utils.getConnection();
        }
        catch (SQLException | GenericEntityException ex) {
            throw new DataAccessException("Unable to obtain a DB connection", ex);
        }
    }

    protected DatabaseType getDatabaseType() {
        DatabaseConfig config = AbstractUpgradeTask.getDatabaseConfig();
        if (config.isPostgres()) {
            return DatabaseTypeFactory.POSTGRES_7_3;
        }
        if (config.isOracle()) {
            return DatabaseTypeFactory.ORACLE_10G;
        }
        if (config.isSqlServer()) {
            return DatabaseTypeFactory.MSSQL;
        }
        if (config.isMySql()) {
            return DatabaseTypeFactory.MYSQL;
        }
        if (config.isH2()) {
            return DatabaseTypeFactory.H2;
        }
        if (config.isHSql()) {
            return DatabaseTypeFactory.HSQL;
        }
        throw new DataAccessException("Unrecognized database configuration: " + config.getDatabaseType());
    }

    protected String convertToSchemaTableName(String tableName) {
        return AbstractUpgradeTask.ensureTablePrefixed(tableName, this.getSchemaName());
    }

    protected String getSchemaName() {
        try {
            GenericHelper helper = this.getDelegator().getEntityHelper("User");
            return EntityConfigUtil.getInstance().getDatasourceInfo(helper.getHelperName()).getSchemaName();
        }
        catch (GenericEntityException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected boolean isORACLE() throws SQLException {
        return AbstractUpgradeTask.getDatabaseConfig().isOracle();
    }

    protected boolean isMSSQL() throws SQLException {
        return AbstractUpgradeTask.getDatabaseConfig().isSqlServer();
    }

    protected boolean isMYSQL() throws SQLException {
        return AbstractUpgradeTask.getDatabaseConfig().isMySql();
    }

    protected boolean isPostgreSQL() {
        return AbstractUpgradeTask.getDatabaseConfig().isPostgres();
    }

    private static DatabaseConfig getDatabaseConfig() {
        return ((DatabaseConfigurationManager)ComponentAccessor.getComponent(DatabaseConfigurationManager.class)).getDatabaseConfiguration();
    }
}

