/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.component.pico.ComponentManager;
import com.atlassian.jira.config.properties.JiraProperties;
import com.atlassian.jira.event.ComponentManagerShutdownEvent;
import com.atlassian.jira.health.HealthChecks;
import com.atlassian.jira.util.ExceptionUtil;
import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginSystemLauncher {
    private static final Logger log = LoggerFactory.getLogger(PluginSystemLauncher.class);
    public static final String INSTANT_DOWN_PROPERTY = "skip.plugin.system.shutdown";
    public static final String FILESIZE_EXCEEDED_CODE_LEGACY_MODE_PROPERTY = "atlassian.rest.filesize.exceeded.statuscode.legacy.enabled";
    private final JiraProperties jiraSystemProperties;

    public PluginSystemLauncher(JiraProperties jiraSystemProperties) {
        this.jiraSystemProperties = jiraSystemProperties;
    }

    public void start() {
        this.enableLegacyStatusCodeForFileSizeLimitExceededException();
        try {
            ComponentManager.getInstance().earlyStartPluginSystem();
            this.clearTomcatResources();
        }
        catch (Exception ex) {
            log.error("A fatal error occured during initialisation. JIRA has been locked.", (Throwable)ex);
            HealthChecks.raiseFatalStartupProblem();
        }
    }

    @Deprecated
    private void enableLegacyStatusCodeForFileSizeLimitExceededException() {
        this.jiraSystemProperties.setProperty(FILESIZE_EXCEEDED_CODE_LEGACY_MODE_PROPERTY, (Object)"true");
    }

    public void lateStart() {
        ComponentManager.getInstance().lateStartPluginSystem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearTomcatResources() {
        block11: {
            try {
                ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                Class<?> contextClassLoaderClass = contextClassLoader.getClass();
                if (!"org.apache.catalina.loader.WebappClassLoader".equals(contextClassLoaderClass.getName())) break block11;
                Field resourceEntriesField = PluginSystemLauncher.getResourceEntriesField(contextClassLoaderClass);
                resourceEntriesField.setAccessible(true);
                Map resourceEntries = (Map)resourceEntriesField.get(contextClassLoader);
                ClassLoader classLoader = contextClassLoader;
                synchronized (classLoader) {
                    Map map = resourceEntries;
                    synchronized (map) {
                        resourceEntries.clear();
                    }
                }
            }
            catch (NoSuchFieldException exception) {
                log.warn(String.format("Tomcat's WebappClassLoader cache for resourceEntries not cleared.Probably using different Tomcat version than 6, 7 or 8 Message: %s", ExceptionUtil.getMessage(exception)));
            }
            catch (IllegalAccessException exception) {
                log.warn("Tomcat's WebappClassLoader cache for resourceEntries not cleared. This should never happen?", (Throwable)exception);
            }
            catch (SecurityException exception) {
                log.warn("Tomcat's WebappClassLoader cache for resourceEntries not cleared. Have we started to use security managers?", (Throwable)exception);
            }
            catch (Exception exception) {
                log.warn(String.format("Tomcat's WebappClassLoader cache for resourceEntries not cleared. Message: %s", ExceptionUtil.getMessage(exception)));
            }
        }
    }

    @VisibleForTesting
    protected static Field getResourceEntriesField(Class<? extends ClassLoader> contextClassLoaderClass) throws NoSuchFieldException {
        Stream<Class<?>> superClassStream = PluginSystemLauncher.superclassStream(contextClassLoaderClass);
        Optional<Field> resourceEntriesField = superClassStream.flatMap(aClass -> Arrays.stream(aClass.getDeclaredFields())).filter(field -> field.getName().equals("resourceEntries")).findFirst();
        return resourceEntriesField.orElseThrow(() -> new NoSuchFieldException("Can't find resourceEntries in class tree of: " + contextClassLoaderClass.getName()));
    }

    private static Stream<Class<?>> superclassStream(Class<?> clazz) {
        Stream.Builder<Class<?>> superclassStreamBuilder = Stream.builder();
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            superclassStreamBuilder.accept(current);
        }
        return superclassStreamBuilder.build();
    }

    public void stop() {
        if (this.jiraSystemProperties.getBoolean(INSTANT_DOWN_PROPERTY).booleanValue()) {
            ComponentManager.getInstance().getComponent(EventPublisher.class).publish((Object)ComponentManagerShutdownEvent.INSTANCE);
        } else {
            ComponentManager.getInstance().stopPluginSystem();
        }
    }
}

