/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.upgrade.tasks;

import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.scheme.SchemeEntity;
import com.atlassian.jira.upgrade.AbstractImmediateUpgradeTask;
import java.util.List;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNotificationSchemeUpgradeTask
extends AbstractImmediateUpgradeTask {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNotificationSchemeUpgradeTask.class);
    private final NotificationSchemeManager notificationSchemeManager;

    public AbstractNotificationSchemeUpgradeTask(NotificationSchemeManager notificationSchemeManager) {
        this.notificationSchemeManager = notificationSchemeManager;
    }

    public void doUpgrade(Long eventIdSource, Long eventIdDestination) throws GenericEntityException {
        try {
            List schemes = this.notificationSchemeManager.getSchemes();
            for (GenericValue schemeGV : schemes) {
                List entities = this.notificationSchemeManager.getEntities(schemeGV, eventIdSource);
                for (GenericValue schemeEntity : entities) {
                    this.addSchemeEntityForDestinationNotification(schemeGV, schemeEntity, eventIdDestination);
                }
            }
        }
        catch (GenericEntityException e) {
            LOG.error("Unable to retrieve all notification schemes.", (Throwable)e);
            throw e;
        }
    }

    private void addSchemeEntityForDestinationNotification(GenericValue schemeGV, GenericValue origSchemeEntity, Long eventIdDestination) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("About to add notification for event id: '" + eventIdDestination + "' for '" + origSchemeEntity.getString("type") + "' to notification scheme '" + schemeGV.getString("name") + "'");
        }
        SchemeEntity schemeEntity = new SchemeEntity(origSchemeEntity.getString("type"), origSchemeEntity.getString("parameter"), (Object)eventIdDestination, (Object)origSchemeEntity.getString("templateId"));
        try {
            this.notificationSchemeManager.createSchemeEntity(schemeGV, schemeEntity);
        }
        catch (GenericEntityException e) {
            LOG.error("Failed to add notification for event id: '" + eventIdDestination + "' for '" + schemeEntity + "' to notification scheme '" + schemeGV.getString("name") + "'!");
        }
    }
}

