/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUsers;

public class LazyLoadingApplicationUser
implements ApplicationUser {
    private final String name;
    private final CrowdService crowdService;
    private ApplicationUser fullUser;

    public LazyLoadingApplicationUser(String name, CrowdService crowdService) {
        this.name = name;
        this.crowdService = crowdService;
    }

    private synchronized ApplicationUser fullUser() {
        if (this.fullUser == null) {
            this.fullUser = this.readFullUser();
        }
        return this.fullUser;
    }

    private ApplicationUser readFullUser() {
        User user = this.crowdService.getUser(this.name);
        return ApplicationUsers.from(user);
    }

    public long getDirectoryId() {
        return this.fullUser().getDirectoryId();
    }

    public User getDirectoryUser() {
        return this.fullUser().getDirectoryUser();
    }

    public String getDisplayName() {
        return this.fullUser().getDisplayName();
    }

    public String getEmailAddress() {
        return this.fullUser().getEmailAddress();
    }

    public String getKey() {
        return this.fullUser().getKey();
    }

    public String getName() {
        return this.name;
    }

    public String getUsername() {
        return this.fullUser().getUsername();
    }

    public boolean isActive() {
        return this.fullUser().isActive();
    }

    public Long getId() {
        return this.fullUser().getId();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ApplicationUser) {
            ApplicationUser other = (ApplicationUser)obj;
            return this.getKey().equals(other.getKey());
        }
        if (obj instanceof User) {
            throw new IllegalArgumentException("You must update your code to use ApplicationUser (you passed User to equals here)");
        }
        return false;
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        return this.getName();
    }
}

