/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.io.Serializable;
import java.util.Objects;
import javax.annotation.Nonnull;

public class AnonymizationResult
implements Serializable {
    private final SimpleErrorCollection validationErrors;
    private final AnonymizeUserService.OperationsReport<Void> operationsReport;

    private AnonymizationResult(@Nonnull ErrorCollection validationErrors) {
        this(validationErrors, new AnonymizeUserService.OperationsReport<Void>());
    }

    private AnonymizationResult(@Nonnull ErrorCollection validationErrors, @Nonnull AnonymizeUserService.OperationsReport<Void> operationsReport) {
        this.validationErrors = new SimpleErrorCollection(Objects.requireNonNull(validationErrors));
        this.operationsReport = Objects.requireNonNull(operationsReport);
    }

    public static AnonymizationResult from(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult) {
        ErrorCollection validationErrors = validationResult.getErrorCollection();
        for (AnonymizeUserService.SingleOperationReport<Void> report : validationResult.getOperationValidation().getReports()) {
            if (report.isValid()) continue;
            validationErrors.addErrorCollection(report.getResult().getErrorCollection());
        }
        return new AnonymizationResult(validationErrors);
    }

    public static AnonymizationResult from(@Nonnull AnonymizeUserService.AnonymizePerformResult performResult) {
        return new AnonymizationResult((ErrorCollection)new SimpleErrorCollection(), performResult.getReport());
    }

    @Nonnull
    public AnonymizeUserService.OperationsReport<Void> getOperationsReport() {
        return this.operationsReport;
    }

    @Nonnull
    public ErrorCollection getValidationErrors() {
        return this.validationErrors;
    }
}

