/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.crowd.embedded.ofbiz.ExtendedUserDao;
import com.atlassian.jira.event.user.anonymize.UserAnonymizationPrevalidateEvent;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.user.anonymize.ServiceOutcomeWithWarnings;
import com.atlassian.jira.user.anonymize.operations.AnonymizeOperationStep;
import com.atlassian.jira.user.anonymize.operations.AnonymizeOperationSteps;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAnonymizeUserService
implements AnonymizeUserService {
    private static final Logger log = LoggerFactory.getLogger(DefaultAnonymizeUserService.class);
    private final UserManager userManager;
    private final I18nHelper.BeanFactory i18nBeanFactory;
    private final GlobalPermissionManager globalPermissionManager;
    private final UserKeyStore userKeyStore;
    private final ExtendedUserDao ofBizUserDao;
    private final AnonymizeOperationSteps anonymizeOperationSteps;
    private final EventPublisher eventPublisher;

    public DefaultAnonymizeUserService(UserManager userManager, I18nHelper.BeanFactory i18nBeanFactory, GlobalPermissionManager globalPermissionManager, UserKeyStore userKeyStore, ExtendedUserDao extendedUserDao, AnonymizeOperationSteps anonymizeOperationSteps, EventPublisher eventPublisher) {
        this.userManager = userManager;
        this.i18nBeanFactory = i18nBeanFactory;
        this.globalPermissionManager = globalPermissionManager;
        this.userKeyStore = userKeyStore;
        this.ofBizUserDao = extendedUserDao;
        this.anonymizeOperationSteps = anonymizeOperationSteps;
        this.eventPublisher = eventPublisher;
    }

    @Override
    @Nonnull
    public AnonymizeUserService.AnonymizeValidationResult preValidateAnonymize(@Nonnull AnonymizeUserService.AnonymizeUserRequest request) {
        log.debug("Publishing userAnonymizationPrevalidateEvent");
        this.eventPublisher.publish((Object)new UserAnonymizationPrevalidateEvent(request.getUserKey()));
        log.debug("Published userAnonymizationPrevalidateEvent");
        return this.validate(request, true);
    }

    @Override
    @Nonnull
    public AnonymizeUserService.AnonymizeValidationResult validateAnonymize(@Nonnull AnonymizeUserService.AnonymizeUserRequest request) {
        return this.validate(request, false);
    }

    private AnonymizeUserService.AnonymizeValidationResult validate(AnonymizeUserService.AnonymizeUserRequest request, boolean preValidate) {
        UserManager.UserState crowdUserState;
        SimpleErrorCollection errors = new SimpleErrorCollection();
        ApplicationUser executor = request.getExecutor();
        I18nHelper i18nBean = this.i18nBeanFactory.getInstance(executor);
        AnonymizeUserService.OperationsReport<Void> validationReport = new AnonymizeUserService.OperationsReport<Void>();
        if (!this.isAdministrator(executor)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.no.permission"));
            return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, request, null, new AnonymizeUserService.OperationsReport<Collection<AffectedEntity>>(), validationReport);
        }
        String originalUserKey = request.getUserKey();
        ApplicationUser userToUpdate = this.userManager.getUserByKeyEvenWhenUnknown(originalUserKey);
        if (!this.isSysAdmin(executor) && this.isSysAdmin(userToUpdate)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.must.be.sysadmin.to.edit.sysadmin"));
            return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, request, null, new AnonymizeUserService.OperationsReport<Collection<AffectedEntity>>(), validationReport);
        }
        if (executor.getKey().equals(request.getUserKey())) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.yourself"));
            return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, request, null, new AnonymizeUserService.OperationsReport<Collection<AffectedEntity>>(), validationReport);
        }
        AnonymizeUserService.AnonymizeProcessData.Builder dataBuilder = AnonymizeUserService.AnonymizeProcessData.newBuilder(request);
        dataBuilder.user(userToUpdate);
        AnonymizeUserService.UserState userState = dataBuilder.build().getUserState();
        if (userState == AnonymizeUserService.UserState.NOT_FOUND) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.user.does.not.exist", originalUserKey));
            return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, request, null, new AnonymizeUserService.OperationsReport<Collection<AffectedEntity>>(), validationReport);
        }
        if (userState == AnonymizeUserService.UserState.PRESENT && (crowdUserState = this.userManager.getUserState(userToUpdate)).isInMultipleDirectories()) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.multiple.directories"));
            return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, request, null, new AnonymizeUserService.OperationsReport<Collection<AffectedEntity>>(), validationReport);
        }
        boolean userkeyAlreadyAnonymized = this.userKeyStore.isSystemKey(userToUpdate.getKey());
        boolean userUsernameAlreadyAnonymized = this.userKeyStore.isSystemKey(userToUpdate.getUsername());
        if (!userkeyAlreadyAnonymized) {
            Optional<String> anonymizedKeyOption = this.getUniqueAnonymizedKey(userToUpdate);
            if (!anonymizedKeyOption.isPresent()) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.cant.generate.userkey", originalUserKey));
                return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, request, null, new AnonymizeUserService.OperationsReport<Collection<AffectedEntity>>(), validationReport);
            }
            String anonymizedKey = anonymizedKeyOption.get();
            dataBuilder.newUserKey(anonymizedKey);
            log.info("User key is not anonymized ({}), should anonymize to ({})", (Object)originalUserKey, (Object)anonymizedKey);
        } else {
            log.info("User key is already anonymized ({}), not need to change it", (Object)userToUpdate.getKey());
        }
        if (!userUsernameAlreadyAnonymized) {
            Optional<String> anonymizedUsernameOption = this.userKeyStore.getUniqueUsernameFromId(userToUpdate.getId());
            if (!anonymizedUsernameOption.isPresent()) {
                errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.cant.generate.username", userToUpdate.getUsername()));
                return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, request, null, new AnonymizeUserService.OperationsReport<Collection<AffectedEntity>>(), validationReport);
            }
            String anonymizedUsername = anonymizedUsernameOption.get();
            log.info("Username is not anonymized ({}), should rename to ({})", (Object)userToUpdate.getUsername(), (Object)anonymizedUsername);
            dataBuilder.newUserName(anonymizedUsername);
        }
        dataBuilder.userDeletedExternally(this.ofBizUserDao.isDeletedExternally(userToUpdate.getDirectoryId(), userToUpdate.getUsername()));
        dataBuilder.userKeyAlreadyAnonymized(userkeyAlreadyAnonymized);
        dataBuilder.userNameAlreadyAnonymized(userUsernameAlreadyAnonymized);
        AnonymizeUserService.AnonymizeProcessData anonymizationData = dataBuilder.build();
        AnonymizeUserService.OperationsReport<Collection<AffectedEntity>> affectedEntitiesOutcome = this.getAffectedEntities(anonymizationData);
        if (!affectedEntitiesOutcome.isValid()) {
            return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, request, null, affectedEntitiesOutcome, validationReport);
        }
        dataBuilder.affectedEntities(affectedEntitiesOutcome.getReports().stream().map(AnonymizeUserService.SingleOperationReport::getResult).map(ServiceOutcomeImpl::get).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList()));
        AnonymizeUserService.AnonymizeProcessData data = dataBuilder.build();
        Collection<AnonymizeUserService.AnonymizeOperation> operationsToPerform = data.getOperationsWeWouldLikeToPerform(preValidate);
        for (AnonymizeUserService.AnonymizeOperation anonymizeOperation : operationsToPerform) {
            AnonymizeOperationStep anonymizeOperationStep = this.anonymizeOperationSteps.getStep(anonymizeOperation);
            if (anonymizeOperationStep == null) continue;
            ServiceResult operationValidationOutcome = anonymizeOperationStep.validate(data, i18nBean, preValidate);
            validationReport.putReport(new AnonymizeUserService.SingleOperationReport<Object>(anonymizeOperationStep.getAnonymizeOperation(), new ServiceOutcomeWithWarnings<Object>(null, operationValidationOutcome.getErrorCollection(), new HashMap<String, ErrorCollection>())));
        }
        return new AnonymizeUserService.AnonymizeValidationResult((ErrorCollection)errors, request, data, affectedEntitiesOutcome, validationReport);
    }

    private AnonymizeUserService.OperationsReport<Collection<AffectedEntity>> getAffectedEntities(AnonymizeUserService.AnonymizeProcessData anonymizationData) {
        AnonymizeUserService.OperationsReport<Collection<AffectedEntity>> operationsReport = new AnonymizeUserService.OperationsReport<Collection<AffectedEntity>>();
        Collection<AnonymizeUserService.AnonymizeOperation> operationsToPerform = anonymizationData.getOperationsWeWouldLikeToPerform(true);
        for (AnonymizeUserService.AnonymizeOperation operation : operationsToPerform) {
            AnonymizeOperationStep step = this.anonymizeOperationSteps.getStep(operation);
            if (step == null) continue;
            ServiceOutcomeWithWarnings<Collection<AffectedEntity>> affectedEntities = step.getAffectedEntities(anonymizationData);
            operationsReport.putReport(new AnonymizeUserService.SingleOperationReport<Collection<AffectedEntity>>(operation, affectedEntities));
        }
        return operationsReport;
    }

    private Optional<String> getUniqueAnonymizedKey(ApplicationUser userToUpdate) {
        return this.userKeyStore.getUniqueKeyFromId(userToUpdate.getId());
    }

    @Override
    @Nonnull
    public AnonymizeUserService.AnonymizePerformResult perform(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult, @Nonnull Context asyncTaskContext) {
        Preconditions.checkArgument((boolean)validationResult.isValid());
        AnonymizeUserService.AnonymizeUserRequest validationRequest = validationResult.getRequest();
        log.debug("Publishing userAnonymizationStartedEvent");
        this.eventPublisher.publish((Object)validationResult.getProcessData().getUserAnonymizationStartedEvent());
        log.debug("Published userAnonymizationStartedEvent");
        AnonymizeUserService.OperationsReport<Void> anonymizeReport = new AnonymizeUserService.OperationsReport<Void>();
        AnonymizeUserService.AnonymizePerformResult anonymizePerformResult = new AnonymizeUserService.AnonymizePerformResult(validationRequest, validationResult.getProcessData(), anonymizeReport);
        for (AnonymizeOperationStep step2 : this.anonymizeOperationSteps.getStepsBlockingAnonymizationProcessOnFail()) {
            step2.performOperation(anonymizeReport, validationResult, asyncTaskContext).ifPresent(anonymizeReport::putReport);
            if (anonymizeReport.isValid()) continue;
            return anonymizePerformResult;
        }
        this.anonymizeOperationSteps.getStepsNotBlockingAnonymizationProcessOnFail().stream().map(step -> step.performOperation(anonymizeReport, validationResult, asyncTaskContext)).forEach(operationReport -> operationReport.ifPresent(anonymizeReport::putReport));
        log.debug("Publishing userAnonymizationFinishedEvent");
        this.eventPublisher.publish((Object)validationResult.getProcessData().getUserAnonymizationFinishedEvent());
        log.debug("Published userAnonymizationFinishedEvent");
        return anonymizePerformResult;
    }

    @Override
    public int getStepCount(@Nonnull AnonymizeUserService.AnonymizeValidationResult anonymizeValidationResult) {
        if (!anonymizeValidationResult.isValid()) {
            return 0;
        }
        return Stream.concat(this.anonymizeOperationSteps.getStepsBlockingAnonymizationProcessOnFail().stream(), this.anonymizeOperationSteps.getStepsNotBlockingAnonymizationProcessOnFail().stream()).mapToInt(step -> step.getNumberOfTasks(anonymizeValidationResult)).sum();
    }

    private boolean isAdministrator(@Nullable ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.ADMINISTER, user);
    }

    private boolean isSysAdmin(@Nullable ApplicationUser user) {
        return this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, user);
    }
}

