/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.anonymize;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.notification.NotificationSchemeManager;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.ContextUtil;
import com.atlassian.jira.user.anonymize.UserAnonymizationHandler;
import com.atlassian.jira.user.anonymize.UserAnonymizationParameter;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nonnull;
import org.ofbiz.core.entity.GenericEntityException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationSchemeAnonymizationHandler
implements UserAnonymizationHandler {
    private static final Logger log = LoggerFactory.getLogger(NotificationSchemeAnonymizationHandler.class);
    private final NotificationSchemeManager notificationSchemeManager;

    public NotificationSchemeAnonymizationHandler(NotificationSchemeManager notificationSchemeManager) {
        this.notificationSchemeManager = notificationSchemeManager;
    }

    @Nonnull
    public List<AffectedEntity> getAffectedEntities(@Nonnull UserAnonymizationParameter parameter) {
        try {
            long affectedSchemes = this.notificationSchemeManager.getEntities("Single_User", parameter.getUserKey()).stream().map(genericValue -> genericValue.getLong("scheme")).distinct().count();
            if (affectedSchemes > 0L) {
                return ImmutableList.of((Object)AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.ANONYMIZE).numberOfOccurrences(Long.valueOf(affectedSchemes)).descriptionKey("admin.projects.notification.scheme").build());
            }
            return ImmutableList.of();
        }
        catch (GenericEntityException e) {
            log.error("Error when looking for user references in notification schemes", (Throwable)e);
            return ImmutableList.of();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ServiceResult update(@Nonnull UserAnonymizationParameter parameter) {
        SimpleErrorCollection error = new SimpleErrorCollection();
        try {
            this.notificationSchemeManager.removeEntities("Single_User", parameter.getUserKey());
        }
        catch (RemoveException e) {
            error.addErrorMessage(e.getMessage());
            log.error("Error while removing user references in notification schemes", (Throwable)e);
        }
        finally {
            ContextUtil.updateProgress(parameter.getContext(), this.getNumberOfTasks(parameter));
        }
        return new ServiceResultImpl((ErrorCollection)error);
    }

    public int getNumberOfTasks(@Nonnull UserAnonymizationParameter userPropertyChangeParameter) {
        return 1;
    }
}

