/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.key;

import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.user.anonymize.handlers.key.GenericUserKeyWithReindexChangeHandler;
import com.atlassian.jira.user.anonymize.handlers.key.info.ForeignKeyInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommentsReindexUserKeyChangeHandler
extends GenericUserKeyWithReindexChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(CommentsReindexUserKeyChangeHandler.class);
    private final CommentManager commentManager;
    private final IssueIndexingService issueIndexingService;

    public CommentsReindexUserKeyChangeHandler(QueryDslAccessor queryDslAccessor, CommentManager commentManager, IssueIndexingService issueIndexingService, ForeignKeyInfo foreignKeyInfo, int numberOfTasksSql, int numberOfTasksReindex) {
        super(queryDslAccessor, foreignKeyInfo, numberOfTasksSql, numberOfTasksReindex);
        this.commentManager = commentManager;
        this.issueIndexingService = issueIndexingService;
    }

    @Override
    protected void reindex(List<Long> ids) {
        List comments = ids.stream().map(arg_0 -> ((CommentManager)this.commentManager).getCommentById(arg_0)).collect(Collectors.toList());
        try {
            log.info("Reindex of comments {} started.", ids);
            long reindexTime = this.issueIndexingService.reIndexComments(comments);
            log.info("Reindex of comments {} took: {} ms", ids, (Object)reindexTime);
        }
        catch (IndexException exception) {
            log.error("Reindex of comments {} failed: {}", ids, (Object)exception.getMessage());
        }
    }
}

