/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.key;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.GenericConfigurationDTO;
import com.atlassian.jira.model.querydsl.QConfigurationContext;
import com.atlassian.jira.model.querydsl.QCustomField;
import com.atlassian.jira.model.querydsl.QFieldConfigScheme;
import com.atlassian.jira.model.querydsl.QFieldConfigSchemeIssueType;
import com.atlassian.jira.model.querydsl.QFieldConfiguration;
import com.atlassian.jira.model.querydsl.QGenericConfiguration;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.ContextUtil;
import com.atlassian.jira.user.anonymize.UserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomFieldDefaultValueUserKeyChangeHandler
implements UserKeyChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(CustomFieldDefaultValueUserKeyChangeHandler.class);
    private final String fieldType;
    protected final QueryDslAccessor queryDslAccessor;
    private final int numberOfTasks;
    private final String descriptionKey;

    private CustomFieldDefaultValueUserKeyChangeHandler(String fieldType, QueryDslAccessor queryDslAccessor, int numberOfTasks, String descriptionKey) {
        this.fieldType = fieldType;
        this.queryDslAccessor = queryDslAccessor;
        this.numberOfTasks = numberOfTasks;
        this.descriptionKey = descriptionKey;
    }

    public static CustomFieldDefaultValueUserKeyChangeHandler singleUserPicker(QueryDslAccessor queryDslAccessor, int numberOfTasksSql) {
        return new CustomFieldDefaultValueUserKeyChangeHandler("com.atlassian.jira.plugin.system.customfieldtypes:userpicker", queryDslAccessor, numberOfTasksSql, "anonymization.fk.cf.userpicker.defaultValue");
    }

    public static CustomFieldDefaultValueUserKeyChangeHandler multiUserPicker(QueryDslAccessor queryDslAccessor, int numberOfTasksSql) {
        return new CustomFieldDefaultValueMultiUserPickerUserKeyChangeHandler("com.atlassian.jira.plugin.system.customfieldtypes:multiuserpicker", queryDslAccessor, numberOfTasksSql, "anonymization.fk.cf.multiuserpicker.defaultValue");
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        long count = this.getAffectedEntities(userPropertyChangeParameter.getOriginal()).size();
        log.info("User {} has {} {} entities to update", new Object[]{userPropertyChangeParameter.getOriginal(), count, "GENERIC_CONFIGURATION.xmlvalue"});
        return count > 0L ? Lists.newArrayList((Object[])new AffectedEntity[]{AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.ANONYMIZE).descriptionKey(this.descriptionKey).numberOfOccurrences(Long.valueOf(count)).build()}) : Collections.emptyList();
    }

    private List<GenericConfigurationDTO> getAffectedEntities(String original) {
        List configurations = this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select((Expression)QGenericConfiguration.GENERIC_CONFIGURATION).from((Expression)QGenericConfiguration.GENERIC_CONFIGURATION)).from((Expression)QFieldConfiguration.FIELD_CONFIGURATION)).from((Expression)QFieldConfigSchemeIssueType.FIELD_CONFIG_SCHEME_ISSUE_TYPE)).from((Expression)QFieldConfigScheme.FIELD_CONFIG_SCHEME)).from((Expression)QConfigurationContext.CONFIGURATION_CONTEXT)).from((Expression)QCustomField.CUSTOM_FIELD)).where((Predicate)QGenericConfiguration.GENERIC_CONFIGURATION.datakey.eq((Expression)QFieldConfiguration.FIELD_CONFIGURATION.id.stringValue()).and((Predicate)QFieldConfigSchemeIssueType.FIELD_CONFIG_SCHEME_ISSUE_TYPE.fieldconfiguration.eq(QFieldConfiguration.FIELD_CONFIGURATION.id)).and((Predicate)QFieldConfigSchemeIssueType.FIELD_CONFIG_SCHEME_ISSUE_TYPE.fieldconfigscheme.eq(QFieldConfigScheme.FIELD_CONFIG_SCHEME.id)).and((Predicate)QConfigurationContext.CONFIGURATION_CONTEXT.fieldconfigscheme.eq(QFieldConfigScheme.FIELD_CONFIG_SCHEME.id)).and((Predicate)QConfigurationContext.CONFIGURATION_CONTEXT.key.eq((Expression)Expressions.asString((String)"customfield_").concat((Expression)QCustomField.CUSTOM_FIELD.id.stringValue()))).and((Predicate)QCustomField.CUSTOM_FIELD.customfieldtypekey.eq((Object)this.fieldType)))).fetch());
        String searchedString = this.xmlString(original);
        return configurations.stream().filter(conf -> Optional.ofNullable(conf.getXmlvalue()).map(value -> value.contains(searchedString)).orElse(false)).collect(Collectors.toList());
    }

    String xmlString(String s) {
        return "<string>" + s + "</string>";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ServiceResult update(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        try {
            String originalUserKey = userPropertyChangeParameter.getOriginal();
            String targetUserKey = userPropertyChangeParameter.getTarget();
            long changed = this.updateAffectedEntities(this.getAffectedEntities(originalUserKey), originalUserKey, targetUserKey);
            log.info("Updated {} {} entities for {}", new Object[]{changed, "GENERIC_CONFIGURATION", originalUserKey});
        }
        finally {
            ContextUtil.updateProgress(userPropertyChangeParameter.getContext(), this.numberOfTasks);
        }
        return new ServiceResultImpl();
    }

    protected long updateAffectedEntities(List<GenericConfigurationDTO> affectedEntities, String originalUserKey, String targetUserKey) {
        return affectedEntities.stream().mapToLong(genericConfiguration -> this.queryDslAccessor.executeQuery(connection -> connection.update((RelationalPath<?>)QGenericConfiguration.GENERIC_CONFIGURATION).set((Path)QGenericConfiguration.GENERIC_CONFIGURATION.xmlvalue, (Object)this.xmlString(targetUserKey)).where((Predicate)QGenericConfiguration.GENERIC_CONFIGURATION.id.eq((Object)genericConfiguration.getId())).execute())).sum();
    }

    public int getNumberOfTasks(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        return this.numberOfTasks;
    }

    private static class CustomFieldDefaultValueMultiUserPickerUserKeyChangeHandler
    extends CustomFieldDefaultValueUserKeyChangeHandler {
        private CustomFieldDefaultValueMultiUserPickerUserKeyChangeHandler(String cfType, QueryDslAccessor queryDslAccessor, int numberOfTasksSql, String descriptionKey) {
            super(cfType, queryDslAccessor, numberOfTasksSql, descriptionKey);
        }

        @Override
        protected long updateAffectedEntities(List<GenericConfigurationDTO> affectedEntities, String originalUserKey, String targetUserKey) {
            return affectedEntities.stream().mapToLong(genericConfiguration -> this.queryDslAccessor.executeQuery(connection -> connection.update((RelationalPath<?>)QGenericConfiguration.GENERIC_CONFIGURATION).set((Path)QGenericConfiguration.GENERIC_CONFIGURATION.xmlvalue, (Object)StringUtils.replace((String)genericConfiguration.getXmlvalue(), (String)this.xmlString(originalUserKey), (String)this.xmlString(targetUserKey))).where((Predicate)QGenericConfiguration.GENERIC_CONFIGURATION.id.eq((Object)genericConfiguration.getId())).execute())).sum();
        }
    }
}

