/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.key;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.model.querydsl.QChangeItem;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.anonymize.UserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.handlers.key.CommentsReindexUserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.handlers.key.CustomFieldDefaultValueUserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.handlers.key.CustomFieldValueUserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.handlers.key.DelegatingChangeHandler;
import com.atlassian.jira.user.anonymize.handlers.key.GenericUserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.handlers.key.IssueHistoryCustomFieldMultiUserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.handlers.key.IssueHistoryCustomFieldUserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.handlers.key.IssueHistoryUserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.handlers.key.IssuesReindexUserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.handlers.key.WorklogsReindexUserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.handlers.key.info.ActionAuthorInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.ActionUpdateAuthorInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.AvatarInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.ColumnLayoutInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.ComponentInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.DraftWorkflowSchemeInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.FavouriteAssociationsInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.FileAttachmentInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.FilterSubscriptionInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.IssueArchivedByInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.IssueAsigneeInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.IssueCreatorInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.IssueHistoryChangeGroupInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.IssueHistoryInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.IssueReporterInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.OAuthspTokenInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.OsCurrentStepInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.OsHistoryStepInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.PortalPageInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.ProjectInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.ProjectRoleActorInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.RememberMeTokenInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.SchemePermissionsInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.SearchRequestAuthorInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.SearchRequestUserInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.SharePermissionsInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.UserAssociationInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.UserHistoryItemInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.WorklogAuthorInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.WorklogUpdateAuthorInfo;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForeignKeyChangeHandler
extends DelegatingChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(ForeignKeyChangeHandler.class);
    private final QueryDslAccessor queryDslAccessor;
    private final DatabaseAccessor databaseAccessor;
    private final EventPublisher eventPublisher;
    private final IssueManager issueManager;
    private final CommentManager commentManager;
    private final WorklogManager worklogManager;
    private final IssueIndexingService issueIndexingService;

    public ForeignKeyChangeHandler(QueryDslAccessor queryDslAccessor, EventPublisher eventPublisher, IssueManager issueManager, CommentManager commentManager, WorklogManager worklogManager, IssueIndexingService issueIndexingService, JiraAuthenticationContext jiraAuthenticationContext, DatabaseAccessor databaseAccessor) {
        super(jiraAuthenticationContext);
        this.queryDslAccessor = queryDslAccessor;
        this.eventPublisher = eventPublisher;
        this.issueManager = issueManager;
        this.commentManager = commentManager;
        this.worklogManager = worklogManager;
        this.issueIndexingService = issueIndexingService;
        this.databaseAccessor = databaseAccessor;
    }

    @Override
    @Nonnull
    public Collection<UserKeyChangeHandler> getHandlers() {
        int numberOfHandlers = 37;
        int stepNumber = 27;
        int stepNumberHalf = 13;
        int stepNumberOtherHalf = 14;
        List<UserKeyChangeHandler> handlers = Arrays.asList(new GenericUserKeyChangeHandler(this.queryDslAccessor, new AvatarInfo(), 27), new GenericUserKeyChangeHandler(this.queryDslAccessor, new ColumnLayoutInfo(), 27), new GenericUserKeyChangeHandler(this.queryDslAccessor, new ComponentInfo(), 27), new GenericUserKeyChangeHandler(this.queryDslAccessor, new DraftWorkflowSchemeInfo(), 27), new GenericUserKeyChangeHandler(this.queryDslAccessor, new FavouriteAssociationsInfo(), 27), new GenericUserKeyChangeHandler(this.queryDslAccessor, new FileAttachmentInfo(), 27), new GenericUserKeyChangeHandler(this.queryDslAccessor, new FilterSubscriptionInfo(), 27), new GenericUserKeyChangeHandler(this.queryDslAccessor, new OsCurrentStepInfo(), 27), new GenericUserKeyChangeHandler(this.queryDslAccessor, new OsHistoryStepInfo(), 27), new GenericUserKeyChangeHandler(this.queryDslAccessor, new PortalPageInfo(), 27), new GenericUserKeyChangeHandler(this.queryDslAccessor, new ProjectInfo(), 27), new GenericUserKeyChangeHandler(this.queryDslAccessor, new ProjectRoleActorInfo(), 27), new GenericUserKeyChangeHandler(this.queryDslAccessor, new RememberMeTokenInfo(), 27), new GenericUserKeyChangeHandler(this.queryDslAccessor, new SchemePermissionsInfo(), 27), new GenericUserKeyChangeHandler(this.queryDslAccessor, new SearchRequestAuthorInfo(), 27), new GenericUserKeyChangeHandler(this.queryDslAccessor, new SearchRequestUserInfo(), 27), new GenericUserKeyChangeHandler(this.queryDslAccessor, new SharePermissionsInfo(), 27), new GenericUserKeyChangeHandler(this.queryDslAccessor, new UserAssociationInfo(), 27), new GenericUserKeyChangeHandler(this.queryDslAccessor, new UserHistoryItemInfo(), 27), new GenericUserKeyChangeHandler(this.queryDslAccessor, new OAuthspTokenInfo(), 27), new GenericUserKeyChangeHandler(this.queryDslAccessor, new IssueHistoryChangeGroupInfo(), 27), new IssueHistoryUserKeyChangeHandler(this.jiraAuthenticationContext, this.queryDslAccessor, this.databaseAccessor, this.issueManager, this.issueIndexingService, 13, 14, (List<IssueHistoryInfo>)ImmutableList.of((Object)new IssueHistoryInfo("assignee", QChangeItem.CHANGE_ITEM.oldvalue), (Object)new IssueHistoryInfo("assignee", QChangeItem.CHANGE_ITEM.newvalue))), new IssueHistoryUserKeyChangeHandler(this.jiraAuthenticationContext, this.queryDslAccessor, this.databaseAccessor, this.issueManager, this.issueIndexingService, 13, 14, (List<IssueHistoryInfo>)ImmutableList.of((Object)new IssueHistoryInfo("reporter", QChangeItem.CHANGE_ITEM.oldvalue), (Object)new IssueHistoryInfo("reporter", QChangeItem.CHANGE_ITEM.newvalue))), new IssueHistoryCustomFieldUserKeyChangeHandler(this.jiraAuthenticationContext, this.queryDslAccessor, this.databaseAccessor, this.issueManager, this.issueIndexingService, 13, 14), new IssueHistoryCustomFieldMultiUserKeyChangeHandler(this.jiraAuthenticationContext, this.queryDslAccessor, this.databaseAccessor, this.issueManager, this.issueIndexingService, 27), new WorklogsReindexUserKeyChangeHandler(this.queryDslAccessor, this.worklogManager, this.issueIndexingService, new WorklogAuthorInfo(), 13, 14), new WorklogsReindexUserKeyChangeHandler(this.queryDslAccessor, this.worklogManager, this.issueIndexingService, new WorklogUpdateAuthorInfo(), 13, 14), new CommentsReindexUserKeyChangeHandler(this.queryDslAccessor, this.commentManager, this.issueIndexingService, new ActionAuthorInfo(), 13, 14), new CommentsReindexUserKeyChangeHandler(this.queryDslAccessor, this.commentManager, this.issueIndexingService, new ActionUpdateAuthorInfo(), 13, 14), new IssuesReindexUserKeyChangeHandler(this.queryDslAccessor, this.issueManager, this.issueIndexingService, new IssueReporterInfo(), 13, 14), new IssuesReindexUserKeyChangeHandler(this.queryDslAccessor, this.issueManager, this.issueIndexingService, new IssueAsigneeInfo(), 13, 14), new IssuesReindexUserKeyChangeHandler(this.queryDslAccessor, this.issueManager, this.issueIndexingService, new IssueCreatorInfo(), 13, 14), new IssuesReindexUserKeyChangeHandler(this.queryDslAccessor, this.issueManager, this.issueIndexingService, new IssueArchivedByInfo(), 13, 14), CustomFieldValueUserKeyChangeHandler.singleUserPicker(this.queryDslAccessor, this.issueManager, this.issueIndexingService, 13, 14), CustomFieldDefaultValueUserKeyChangeHandler.singleUserPicker(this.queryDslAccessor, 27), CustomFieldValueUserKeyChangeHandler.multiUserPicker(this.queryDslAccessor, this.issueManager, this.issueIndexingService, 13, 14), CustomFieldDefaultValueUserKeyChangeHandler.multiUserPicker(this.queryDslAccessor, 27));
        if (handlers.size() != 37) {
            throw new IllegalStateException(String.format("Declared number of handlers (%d) is different than the actual (%d)!", 37, handlers.size()));
        }
        return handlers;
    }

    @Override
    public void afterHandlersExecution() {
        log.info("Clear caches after FK update");
        this.eventPublisher.publish((Object)ClearCacheEvent.INSTANCE);
    }
}

