/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.key;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.anonymize.ContextUtil;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.anonymize.handlers.key.GenericUserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.handlers.key.info.ForeignKeyInfo;
import java.util.List;
import javax.annotation.Nonnull;

public abstract class GenericUserKeyWithReindexChangeHandler
extends GenericUserKeyChangeHandler {
    protected final int numberOfTasksSql;
    protected final int numberOfTasksReindex;

    public GenericUserKeyWithReindexChangeHandler(QueryDslAccessor queryDslAccessor, ForeignKeyInfo foreignKeyInfo, int numberOfTasksSql, int numberOfTasksReindex) {
        super(queryDslAccessor, foreignKeyInfo, numberOfTasksSql + numberOfTasksReindex);
        this.numberOfTasksSql = numberOfTasksSql;
        this.numberOfTasksReindex = numberOfTasksReindex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ServiceResult update(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        List<Long> ids = this.getIdsOfAffectedEntities(userPropertyChangeParameter.getOriginal());
        Context context = userPropertyChangeParameter.getContext();
        ServiceResult result = super.update(userPropertyChangeParameter, this.numberOfTasksSql);
        try {
            if (!ids.isEmpty()) {
                this.reindex(ids);
            }
        }
        finally {
            ContextUtil.updateProgress(context, this.numberOfTasksReindex);
        }
        return result;
    }

    protected abstract void reindex(List<Long> var1);
}

