/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.key;

import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.DatabaseVendor;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.model.querydsl.QChangeItem;
import com.atlassian.jira.model.querydsl.QCustomField;
import com.atlassian.jira.model.querydsl.QOSPropertyEntry;
import com.atlassian.jira.model.querydsl.QOSPropertyString;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.anonymize.handlers.key.IssueHistoryUserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.handlers.key.info.IssueHistoryInfo;
import com.atlassian.jira.user.anonymize.handlers.utils.QueryDslUtils;
import com.google.common.collect.ImmutableList;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public class IssueHistoryCustomFieldUserKeyChangeHandler
extends IssueHistoryUserKeyChangeHandler {
    private static final String DESCRIPTION_KEY = "anonymization.fk.issueHistory.customField";
    private static final String FIELDTYPE = "com.atlassian.jira.plugin.system.customfieldtypes:userpicker";

    public IssueHistoryCustomFieldUserKeyChangeHandler(JiraAuthenticationContext jiraAuthenticationContext, QueryDslAccessor queryDslAccessor, DatabaseAccessor databaseAccessor, IssueManager issueManager, IssueIndexingService issueIndexingService, int stepNumberHalf, int stepNumberOtherHalf) {
        super(jiraAuthenticationContext, queryDslAccessor, databaseAccessor, issueManager, issueIndexingService, stepNumberHalf, stepNumberOtherHalf, (List<IssueHistoryInfo>)ImmutableList.of((Object)new CustomInfo(QChangeItem.CHANGE_ITEM.oldvalue), (Object)new CustomInfo(QChangeItem.CHANGE_ITEM.newvalue)));
    }

    @Override
    protected String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    @Override
    protected void reindex(Collection<Long> changeItemIds) {
    }

    private static class CustomInfo
    extends IssueHistoryInfo {
        private CustomInfo(StringPath column) {
            super(null, column);
        }

        @Override
        public Predicate getWhere(String original, @Nullable DatabaseVendor databaseVendor) {
            BooleanExpression columnEquals = this.column.eq((Object)original);
            StringPath translatedField = QOSPropertyString.O_S_PROPERTY_STRING.value;
            if (DatabaseVendor.SQL_SERVER.equals((Object)databaseVendor)) {
                columnEquals = QueryDslUtils.mssqlCastNTextToNvarchar(this.column).eq((Object)original);
                translatedField = QueryDslUtils.mssqlCastNTextToNvarchar(QOSPropertyString.O_S_PROPERTY_STRING.value);
            } else if (DatabaseVendor.ORACLE.equals((Object)databaseVendor)) {
                columnEquals = QueryDslUtils.oracleCastClobToNvarchar(this.column).eq((Object)original);
            }
            return QChangeItem.CHANGE_ITEM.fieldtype.eq((Object)"custom").and((Predicate)columnEquals).and((Predicate)QChangeItem.CHANGE_ITEM.field.in((SubQueryExpression)((SQLQuery)SQLExpressions.select((Expression)translatedField).from(new Expression[]{QOSPropertyString.O_S_PROPERTY_STRING, QCustomField.CUSTOM_FIELD, QOSPropertyEntry.O_S_PROPERTY_ENTRY})).where(new Predicate[]{QOSPropertyEntry.O_S_PROPERTY_ENTRY.id.eq(QOSPropertyString.O_S_PROPERTY_STRING.id), QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityName.eq((Object)"CustomField"), QOSPropertyEntry.O_S_PROPERTY_ENTRY.propertyKey.like("jira.translation.custom.field%.name.%"), QCustomField.CUSTOM_FIELD.customfieldtypekey.eq((Object)IssueHistoryCustomFieldUserKeyChangeHandler.FIELDTYPE), QCustomField.CUSTOM_FIELD.id.eq(QOSPropertyEntry.O_S_PROPERTY_ENTRY.entityId)})).or((Predicate)QChangeItem.CHANGE_ITEM.field.in((SubQueryExpression)((SQLQuery)SQLExpressions.select((Expression)QCustomField.CUSTOM_FIELD.name).from((Expression)QCustomField.CUSTOM_FIELD)).where((Predicate)QCustomField.CUSTOM_FIELD.customfieldtypekey.eq((Object)IssueHistoryCustomFieldUserKeyChangeHandler.FIELDTYPE)))));
        }
    }
}

