/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.key;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.database.DatabaseAccessor;
import com.atlassian.jira.database.DatabaseVendor;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.model.querydsl.QChangeGroup;
import com.atlassian.jira.model.querydsl.QChangeItem;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.ContextUtil;
import com.atlassian.jira.user.anonymize.UserKeyChangeHandler;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.anonymize.handlers.key.info.IssueHistoryInfo;
import com.google.common.collect.Lists;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.Expressions;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueHistoryUserKeyChangeHandler
implements UserKeyChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(IssueHistoryUserKeyChangeHandler.class);
    private static final String DESCRIPTION_KEY = "anonymization.fk.issueHistory.userKey";
    private static final int CHUNK_SIZE = 1000;
    protected final JiraAuthenticationContext jiraAuthenticationContext;
    protected final QueryDslAccessor queryDslAccessor;
    private final IssueManager issueManager;
    private final IssueIndexingService issueIndexingService;
    private final int stepNumberHalf;
    private final int stepNumberOtherHalf;
    private final List<IssueHistoryInfo> infos;
    private final DatabaseAccessor databaseAccessor;

    public IssueHistoryUserKeyChangeHandler(JiraAuthenticationContext jiraAuthenticationContext, QueryDslAccessor queryDslAccessor, DatabaseAccessor databaseAccessor, IssueManager issueManager, IssueIndexingService issueIndexingService, int stepNumberHalf, int stepNumberOtherHalf, List<IssueHistoryInfo> infos) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.queryDslAccessor = queryDslAccessor;
        this.issueManager = issueManager;
        this.issueIndexingService = issueIndexingService;
        this.stepNumberHalf = stepNumberHalf;
        this.stepNumberOtherHalf = stepNumberOtherHalf;
        this.infos = infos;
        this.databaseAccessor = databaseAccessor;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        String original = userPropertyChangeParameter.getOriginal();
        long count = this.getInfos().stream().mapToLong(i -> this.getAffectedEntitiesCount(original, (IssueHistoryInfo)i)).sum();
        log.info("User {} has {} {} entities to update", new Object[]{original, count, QChangeItem.CHANGE_ITEM.getTableName()});
        return count > 0L ? Lists.newArrayList((Object[])new AffectedEntity[]{AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.ANONYMIZE).descriptionKey(this.getDescriptionKey()).numberOfOccurrences(Long.valueOf(count)).build()}) : Collections.emptyList();
    }

    protected String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ServiceResult update(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        String original = userPropertyChangeParameter.getOriginal();
        String target = userPropertyChangeParameter.getTarget();
        Set<Long> allChangeItemIds = Collections.emptySet();
        try {
            try {
                allChangeItemIds = this.getInfos().stream().flatMap(info -> this.getAffectedEntitiesIds(original, (IssueHistoryInfo)info).stream()).collect(Collectors.toSet());
                long updated = this.getInfos().stream().mapToLong(info -> this.updateCustomField((IssueHistoryInfo)info, original, target)).sum();
                log.info("Updated {} {} entities for {}", new Object[]{updated, QChangeItem.CHANGE_ITEM.getTableName(), original});
            }
            finally {
                ContextUtil.updateProgress(userPropertyChangeParameter.getContext(), this.stepNumberHalf);
            }
        }
        finally {
            try {
                this.reindex(allChangeItemIds);
            }
            finally {
                ContextUtil.updateProgress(userPropertyChangeParameter.getContext(), this.stepNumberOtherHalf);
            }
        }
        return new ServiceResultImpl();
    }

    public int getNumberOfTasks(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        return this.stepNumberHalf + this.stepNumberOtherHalf;
    }

    protected List<IssueHistoryInfo> getInfos() {
        return this.infos;
    }

    private long getAffectedEntitiesCount(String original, IssueHistoryInfo foreignKeyInfo) {
        return this.queryDslAccessor.executeQuery(connection -> this.getBaseQuery(original, foreignKeyInfo, connection).fetchCount());
    }

    protected List<Long> getAffectedEntitiesIds(String original, IssueHistoryInfo foreignKeyInfo) {
        return this.queryDslAccessor.executeQuery(connection -> this.getBaseQuery(original, foreignKeyInfo, connection).fetch());
    }

    protected SQLQuery<Long> getBaseQuery(String original, IssueHistoryInfo foreignKeyInfo, DbConnection connection) {
        return (SQLQuery)((SQLQuery)connection.newSqlQuery().select(foreignKeyInfo.getSelect()).from((Expression)foreignKeyInfo.getTable())).where(foreignKeyInfo.getWhere(original, this.databaseAccessor.getDatabaseVendor()));
    }

    protected long updateCustomField(IssueHistoryInfo info, String original, String target) {
        return this.queryDslAccessor.executeQuery(connection -> {
            long affected = connection.update((RelationalPath<?>)info.getTable()).set(info.getColumn().get(), (Object)target).where((Predicate)QChangeItem.CHANGE_ITEM.id.in(this.getInQuery(original, info, connection))).execute();
            return affected;
        });
    }

    private SQLQuery<Long> getInQuery(String original, IssueHistoryInfo info, DbConnection connection) {
        SQLQuery<Long> baseQuery = this.getBaseQuery(original, info, connection);
        if (this.databaseAccessor.getDatabaseVendor() == DatabaseVendor.MY_SQL) {
            return (SQLQuery)SQLExpressions.select((Expression)Expressions.numberPath(Long.class, (String)"id")).from((Expression)baseQuery.as("innerQuery"));
        }
        return baseQuery;
    }

    protected void reindex(Collection<Long> changeItemIds) {
        Collection ids = Lists.partition(new ArrayList<Long>(changeItemIds), (int)1000).stream().flatMap(idsPartition -> this.getIssueIdsFromChangeItemIds((Collection<Long>)idsPartition).stream()).collect(Collectors.toSet());
        List issues = this.issueManager.getIssueObjects(ids);
        try {
            log.info("Reindex of issues {} started.", (Object)ids);
            long reindexTime = this.issueIndexingService.reIndexIssueObjects((Collection)issues, IssueIndexingParams.INDEX_ALL);
            log.info("Reindex of issues {} took: {} ms", (Object)ids, (Object)reindexTime);
        }
        catch (IndexException exception) {
            log.error("Reindex of issues {} failed: {}", (Object)ids, (Object)exception.getMessage());
        }
    }

    private Collection<Long> getIssueIdsFromChangeItemIds(Collection<Long> changeItemIds) {
        return this.queryDslAccessor.executeQuery(connection -> ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)connection.newSqlQuery().select(QChangeGroup.CHANGE_GROUP.issue).from((Expression)QChangeGroup.CHANGE_GROUP)).innerJoin((EntityPath)QChangeItem.CHANGE_ITEM)).on((Predicate)QChangeGroup.CHANGE_GROUP.id.eq(QChangeItem.CHANGE_ITEM.group))).where((Predicate)QChangeItem.CHANGE_ITEM.id.in(changeItemIds))).fetch());
    }
}

