/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.key;

import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexingParams;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.user.anonymize.handlers.key.GenericUserKeyWithReindexChangeHandler;
import com.atlassian.jira.user.anonymize.handlers.key.info.ForeignKeyInfo;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssuesReindexUserKeyChangeHandler
extends GenericUserKeyWithReindexChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(IssuesReindexUserKeyChangeHandler.class);
    private final IssueManager issueManager;
    private final IssueIndexingService issueIndexingService;

    public IssuesReindexUserKeyChangeHandler(QueryDslAccessor queryDslAccessor, IssueManager issueManager, IssueIndexingService issueIndexingService, ForeignKeyInfo foreignKeyInfo, int stepNumberHalf, int stepNumberOtherHalf) {
        super(queryDslAccessor, foreignKeyInfo, stepNumberHalf, stepNumberOtherHalf);
        this.issueManager = issueManager;
        this.issueIndexingService = issueIndexingService;
    }

    @Override
    protected void reindex(List<Long> ids) {
        List issues = this.issueManager.getIssueObjects(ids);
        try {
            log.info("Reindex of issues {} started.", ids);
            long reindexTime = this.issueIndexingService.reIndexIssueObjects((Collection)issues, IssueIndexingParams.INDEX_ISSUE_ONLY);
            log.info("Reindex of issues {} took: {} ms", ids, (Object)reindexTime);
        }
        catch (IndexException exception) {
            log.error("Reindex of issues {} failed: {}", ids, (Object)exception.getMessage());
        }
    }
}

