/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.key;

import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.issue.index.IndexException;
import com.atlassian.jira.issue.index.IssueIndexingService;
import com.atlassian.jira.issue.worklog.WorklogManager;
import com.atlassian.jira.user.anonymize.handlers.key.GenericUserKeyWithReindexChangeHandler;
import com.atlassian.jira.user.anonymize.handlers.key.info.ForeignKeyInfo;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorklogsReindexUserKeyChangeHandler
extends GenericUserKeyWithReindexChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(WorklogsReindexUserKeyChangeHandler.class);
    private final WorklogManager worklogManager;
    private final IssueIndexingService issueIndexingService;

    public WorklogsReindexUserKeyChangeHandler(QueryDslAccessor queryDslAccessor, WorklogManager worklogManager, IssueIndexingService issueIndexingService, ForeignKeyInfo foreignKeyInfo, int numberOfTasksSql, int numberOfTasksReindex) {
        super(queryDslAccessor, foreignKeyInfo, numberOfTasksSql, numberOfTasksReindex);
        this.worklogManager = worklogManager;
        this.issueIndexingService = issueIndexingService;
    }

    @Override
    protected void reindex(List<Long> ids) {
        List worklogs = ids.stream().map(arg_0 -> ((WorklogManager)this.worklogManager).getById(arg_0)).collect(Collectors.toList());
        try {
            log.info("Reindex of worklogs {} started.", ids);
            long reindexTime = this.issueIndexingService.reIndexWorklogs(worklogs);
            log.info("Reindex of worklogs {} took: {} ms", ids, (Object)reindexTime);
        }
        catch (IndexException exception) {
            log.error("Reindex of worklogs {} failed: {}", ids, (Object)exception.getMessage());
        }
    }
}

