/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.handlers.username;

import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.bc.ServiceResultImpl;
import com.atlassian.jira.database.DbConnection;
import com.atlassian.jira.database.QueryDslAccessor;
import com.atlassian.jira.model.querydsl.QChangeItem;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AffectedEntityType;
import com.atlassian.jira.user.anonymize.ContextUtil;
import com.atlassian.jira.user.anonymize.UserNameChangeHandler;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.anonymize.handlers.key.info.ForeignKeyInfo;
import com.atlassian.jira.user.anonymize.handlers.key.info.IssueHistoryInfo;
import com.google.common.collect.Lists;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.sql.RelationalPath;
import com.querydsl.sql.SQLQuery;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueHistoryDescriptionUsernameChangeHandler
implements UserNameChangeHandler {
    private static final Logger log = LoggerFactory.getLogger(IssueHistoryDescriptionUsernameChangeHandler.class);
    private static final String DESCRIPTION_KEY = "anonymization.username.issueHistory.description";
    private final QueryDslAccessor queryDslAccessor;
    private final int numberOfTasks;

    public IssueHistoryDescriptionUsernameChangeHandler(QueryDslAccessor queryDslAccessor, int numberOfTasks) {
        this.queryDslAccessor = queryDslAccessor;
        this.numberOfTasks = numberOfTasks;
    }

    @Nonnull
    public Collection<AffectedEntity> getAffectedEntities(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        String original = userPropertyChangeParameter.getOriginal();
        long count = this.getInfos().stream().mapToLong(i -> this.getAffectedEntitiesCount(original, (ForeignKeyInfo)i)).sum();
        log.info("User {} has {} {} entities to update", new Object[]{original, count, QChangeItem.CHANGE_ITEM.getTableName()});
        return count > 0L ? Lists.newArrayList((Object[])new AffectedEntity[]{AffectedEntity.newBuilder((AffectedEntityType)AffectedEntityType.ANONYMIZE).descriptionKey(this.getDescriptionKey()).numberOfOccurrences(Long.valueOf(count)).build()}) : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ServiceResult update(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        String original = userPropertyChangeParameter.getOriginal();
        String target = userPropertyChangeParameter.getTarget();
        try {
            long updated = this.getInfos().stream().mapToLong(info -> this.getAffectedEntitiesIds(original, (ForeignKeyInfo)info).stream().mapToLong(id -> this.updateCustomField((Long)id, (IssueHistoryInfo)info, original, target)).sum()).sum();
            log.info("Updated {} {} entities for {}", new Object[]{updated, QChangeItem.CHANGE_ITEM.getTableName(), original});
        }
        finally {
            ContextUtil.updateProgress(userPropertyChangeParameter.getContext(), this.getNumberOfTasks(userPropertyChangeParameter));
        }
        return new ServiceResultImpl();
    }

    public int getNumberOfTasks(@Nonnull UserPropertyChangeParameter userPropertyChangeParameter) {
        return this.numberOfTasks;
    }

    private List<IssueHistoryInfo> getInfos() {
        return Arrays.asList(new DescriptionInfo(QChangeItem.CHANGE_ITEM.oldstring), new DescriptionInfo(QChangeItem.CHANGE_ITEM.newstring));
    }

    private String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    private List<Long> getAffectedEntitiesIds(String original, ForeignKeyInfo foreignKeyInfo) {
        return this.queryDslAccessor.executeQuery(connection -> this.getBaseQuery(original, foreignKeyInfo, connection).fetch());
    }

    private long getAffectedEntitiesCount(String original, ForeignKeyInfo foreignKeyInfo) {
        return this.queryDslAccessor.executeQuery(connection -> this.getBaseQuery(original, foreignKeyInfo, connection).fetchCount());
    }

    protected SQLQuery<Long> getBaseQuery(String original, ForeignKeyInfo foreignKeyInfo, DbConnection connection) {
        return (SQLQuery)((SQLQuery)connection.newSqlQuery().select(foreignKeyInfo.getSelect()).from((Expression)foreignKeyInfo.getTable())).where(foreignKeyInfo.getWhere(original));
    }

    private long updateCustomField(Long id, IssueHistoryInfo info, String original, String target) {
        return this.queryDslAccessor.executeQuery(connection -> {
            String value = (String)((SQLQuery)((SQLQuery)connection.newSqlQuery().select((Expression)info.getColumn().get()).from((Expression)info.getTable())).where((Predicate)QChangeItem.CHANGE_ITEM.id.eq((Object)id))).fetchFirst();
            String newMention = IssueHistoryDescriptionUsernameChangeHandler.newMention(target);
            String oldMention = IssueHistoryDescriptionUsernameChangeHandler.newMention(original);
            String newValue = value.replace(oldMention, newMention);
            long affected = connection.update((RelationalPath<?>)info.getTable()).set(info.getColumn().get(), (Object)newValue).where((Predicate)QChangeItem.CHANGE_ITEM.id.eq((Object)id)).execute();
            return affected;
        });
    }

    private static String newMention(String userKey) {
        return String.format("[~%s]", userKey);
    }

    static class DescriptionInfo
    extends IssueHistoryInfo {
        private DescriptionInfo(StringPath column) {
            super("description", column);
        }

        @Override
        public Predicate getWhere(String original) {
            String searchString = IssueHistoryDescriptionUsernameChangeHandler.newMention(original);
            return QChangeItem.CHANGE_ITEM.fieldtype.eq((Object)"jira").and((Predicate)QChangeItem.CHANGE_ITEM.field.eq((Object)this.field).and((Predicate)this.column.contains(searchString)));
        }
    }
}

