/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.name;

import com.atlassian.jira.crowd.embedded.ofbiz.ExtendedUserDao;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.ApplicationUserEntity;
import com.atlassian.jira.user.anonymize.UserPropertyChangeManager;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.anonymize.UserPropertyChangeService;
import com.atlassian.jira.user.anonymize.name.UserNameChangeManager;
import com.atlassian.jira.user.anonymize.name.UserNameChangeService;
import com.atlassian.jira.user.util.UserKeyStore;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class DefaultUserNameChangeService
extends UserNameChangeService {
    private final UserManager userManager;
    private final UserKeyStore userKeyStore;
    private final UserNameChangeManager userNameChangeManager;
    private final ExtendedUserDao extendedUserDao;

    public DefaultUserNameChangeService(UserManager userManager, UserKeyStore userKeyStore, UserNameChangeManager userNameChangeManager, ExtendedUserDao extendedUserDao) {
        this.userManager = userManager;
        this.userKeyStore = userKeyStore;
        this.userNameChangeManager = userNameChangeManager;
        this.extendedUserDao = extendedUserDao;
    }

    @Override
    @Nonnull
    protected UserPropertyChangeManager getManager() {
        return this.userNameChangeManager;
    }

    @Override
    @Nonnull
    protected String getHandlerDescriptionKey() {
        return "admin.user.name.change.handler.name.change";
    }

    @Override
    @Nonnull
    public UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter> validateUserPropertyChange(@Nonnull UserPropertyChangeService.UserPropertyChangeRequest<UserPropertyChangeParameter> userPropertyChangeRequest) {
        boolean canRenameUser;
        UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter> validateCommonResult = this.validateCommon(userPropertyChangeRequest);
        if (!validateCommonResult.isValid()) {
            return validateCommonResult;
        }
        I18nHelper i18nBean = this.getI18nBean(userPropertyChangeRequest.getLoggedInUser());
        SimpleErrorCollection errors = new SimpleErrorCollection();
        String originalUserName = userPropertyChangeRequest.getUserPropertyChangeParameter().getOriginal();
        ApplicationUser userToUpdate = this.userManager.getUserByNameEvenWhenUnknown(originalUserName);
        String anonymizedUserName = userPropertyChangeRequest.getUserPropertyChangeParameter().getTarget();
        Optional<ApplicationUserEntity> existingUserWithDestinationKey = this.userKeyStore.getUserForUsername(anonymizedUserName);
        if (existingUserWithDestinationKey.isPresent()) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.name.change.destination.name.already.exists", anonymizedUserName));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        if (userToUpdate == null) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.name.change.user.does.not.exist", originalUserName));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        if (userToUpdate.getDirectoryId() == -1L && userToUpdate.getId().equals(-1L)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.name.change.user.does.not.exist", originalUserName));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        boolean bl = canRenameUser = this.userManager.canRenameUser(userToUpdate) || this.userIsDeletedExternally(userToUpdate);
        if (userToUpdate.getDirectoryId() != -1L && !canRenameUser) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.name.cant.rename"));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest);
    }

    private boolean userIsDeletedExternally(@Nullable ApplicationUser userToUpdate) {
        if (userToUpdate == null) {
            return false;
        }
        return this.extendedUserDao.isDeletedExternally(userToUpdate.getDirectoryId(), userToUpdate.getUsername());
    }

    @Override
    @Nonnull
    public UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter> validateUserPropertyChangeInOtherEntities(@Nonnull UserPropertyChangeService.UserPropertyChangeRequest<UserPropertyChangeParameter> userPropertyChangeRequest) {
        return this.validateCommon(userPropertyChangeRequest);
    }

    private UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter> validateCommon(@Nonnull UserPropertyChangeService.UserPropertyChangeRequest<UserPropertyChangeParameter> userPropertyChangeRequest) {
        ApplicationUser loggedInUser = userPropertyChangeRequest.getLoggedInUser();
        I18nHelper i18nBean = this.getI18nBean(loggedInUser);
        SimpleErrorCollection errors = new SimpleErrorCollection();
        String originalUserName = userPropertyChangeRequest.getUserPropertyChangeParameter().getOriginal();
        ApplicationUser userToUpdate = this.userManager.getUserByNameEvenWhenUnknown(originalUserName);
        if (!this.isAdministrator(loggedInUser)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.name.change.no.permission"));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        if (!this.isSysAdmin(loggedInUser) && this.isSysAdmin(userToUpdate)) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.name.change.must.be.sysadmin.to.edit.sysadmin"));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        if (Objects.equals(userPropertyChangeRequest.getUserPropertyChangeParameter().getOriginal(), userPropertyChangeRequest.getUserPropertyChangeParameter().getTarget())) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.name.change.names.equal"));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        if (StringUtils.isBlank((CharSequence)userPropertyChangeRequest.getUserPropertyChangeParameter().getTarget())) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.name.change.anonymize.name.blank"));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        if (userPropertyChangeRequest.getLoggedInUser().getUsername().equals(userPropertyChangeRequest.getUserPropertyChangeParameter().getOriginal())) {
            errors.addErrorMessage(i18nBean.getText("admin.errors.user.name.change.yourself"));
            return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest, (ErrorCollection)errors);
        }
        return new UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter>(userPropertyChangeRequest);
    }
}

