/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.operations;

import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.user.anonymize.operations.AnonymizeOperationStep;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AnonymizeOperationSteps {
    private final Map<AnonymizeUserService.AnonymizeOperation, AnonymizeOperationStep> operationToStep;
    private final AnonymizeUserService.AnonymizeOperation[] BLOCKING_OPERATIONS;
    private final AnonymizeUserService.AnonymizeOperation[] NON_BLOCKING_OPERATIONS;

    public AnonymizeOperationSteps(@Nonnull AnonymizeOperationStep[] steps) {
        Objects.requireNonNull(steps);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Arrays.stream(steps).forEach(handler -> builder.put((Object)handler.getAnonymizeOperation(), handler));
        this.operationToStep = builder.build();
        this.BLOCKING_OPERATIONS = new AnonymizeUserService.AnonymizeOperation[]{AnonymizeUserService.AnonymizeOperation.USER_TRANSFER_OWNERSHIP_PLUGIN_POINTS, AnonymizeUserService.AnonymizeOperation.USER_DISABLE};
        this.NON_BLOCKING_OPERATIONS = new AnonymizeUserService.AnonymizeOperation[]{AnonymizeUserService.AnonymizeOperation.USER_ANONYMIZE_PLUGIN_POINTS, AnonymizeUserService.AnonymizeOperation.USER_EXTERNAL_ID_CHANGE, AnonymizeUserService.AnonymizeOperation.USER_KEY_CHANGE, AnonymizeUserService.AnonymizeOperation.USER_KEY_CHANGE_PLUGIN_POINTS, AnonymizeUserService.AnonymizeOperation.USER_NAME_CHANGE, AnonymizeUserService.AnonymizeOperation.USER_NAME_CHANGE_PLUGIN_POINTS};
    }

    public Collection<AnonymizeOperationStep> getStepsBlockingAnonymizationProcessOnFail() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AnonymizeUserService.AnonymizeOperation operation : this.BLOCKING_OPERATIONS) {
            Optional.ofNullable(this.operationToStep.get((Object)operation)).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        }
        return builder.build();
    }

    public Collection<AnonymizeOperationStep> getStepsNotBlockingAnonymizationProcessOnFail() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AnonymizeUserService.AnonymizeOperation operation : this.NON_BLOCKING_OPERATIONS) {
            Optional.ofNullable(this.operationToStep.get((Object)operation)).ifPresent(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        }
        return builder.build();
    }

    @Nullable
    public AnonymizeOperationStep getStep(@Nonnull AnonymizeUserService.AnonymizeOperation anonymizeOperation) {
        return this.operationToStep.get((Object)anonymizeOperation);
    }
}

