/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.operations;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.embedded.impl.ImmutableUser;
import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.DelegatingApplicationUser;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.user.anonymize.ServiceOutcomeWithWarnings;
import com.atlassian.jira.user.anonymize.operations.AnonymizeOperationStep;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDisableOperationStep
implements AnonymizeOperationStep {
    private static final Logger log = LoggerFactory.getLogger(UserDisableOperationStep.class);
    private final UserManager userManager;

    public UserDisableOperationStep(UserManager userManager) {
        this.userManager = userManager;
    }

    public Optional<AnonymizeUserService.SingleOperationReport<Void>> performOperation(AnonymizeUserService.OperationsReport anonymizeReport, AnonymizeUserService.AnonymizeValidationResult validationResult, @Nonnull Context asyncTaskContext) {
        AnonymizeUserService.AnonymizeProcessData processData = validationResult.getProcessData();
        if (this.shouldDeactivateUser(processData)) {
            ApplicationUser editedUser = processData.getUser();
            log.info("Deactivating user ({})", (Object)processData.getUser());
            ImmutableUser.Builder builder = ImmutableUser.newUser((User)editedUser.getDirectoryUser());
            builder.active(false);
            try {
                this.userManager.updateUser((ApplicationUser)new DelegatingApplicationUser(editedUser.getId(), editedUser.getKey(), builder.toUser()));
            }
            catch (Exception e) {
                log.error("Error while disabling Crowd user", (Throwable)e);
                SimpleErrorCollection errorCollection = new SimpleErrorCollection();
                errorCollection.addErrorMessage(e.getMessage());
                return Optional.of(new AnonymizeUserService.SingleOperationReport<Object>(AnonymizeUserService.AnonymizeOperation.USER_DISABLE, new ServiceOutcomeWithWarnings<Object>(null, (ErrorCollection)errorCollection, new HashMap<String, ErrorCollection>())));
            }
            return Optional.of(new AnonymizeUserService.SingleOperationReport<Object>(AnonymizeUserService.AnonymizeOperation.USER_DISABLE, new ServiceOutcomeWithWarnings<Object>(null, new HashMap<String, ErrorCollection>())));
        }
        log.warn("Wanted to perform operation but parameters are invalid. Skipping deactivating user");
        return Optional.empty();
    }

    private boolean shouldDeactivateUser(AnonymizeUserService.AnonymizeProcessData processData) {
        return processData != null && processData.handleOperation(AnonymizeUserService.AnonymizeOperation.USER_DISABLE);
    }

    @Override
    @Nonnull
    public ServiceResult validate(@Nonnull AnonymizeUserService.AnonymizeProcessData anonymizationProcessData, I18nHelper i18nBean, boolean preValidate) {
        if (anonymizationProcessData.getUserState() == AnonymizeUserService.UserState.PRESENT) {
            ApplicationUser userToUpdate = anonymizationProcessData.getUser();
            if (userToUpdate != null && userToUpdate.isActive()) {
                if (!this.userManager.canUpdateUser(userToUpdate)) {
                    SimpleErrorCollection errors = new SimpleErrorCollection();
                    errors.addErrorMessage(i18nBean.getText("admin.errors.user.anonymize.cant.update"));
                    return ServiceOutcomeImpl.from((ErrorCollection)errors);
                }
            } else {
                log.info("User ({}) is already disabled, should skip disabling user", (Object)Optional.ofNullable(userToUpdate).map(ApplicationUser::getKey).orElse("[unknown key]"));
            }
        }
        return ServiceOutcomeImpl.ok(null);
    }

    @Override
    @Nonnull
    public ServiceOutcomeWithWarnings<Collection<AffectedEntity>> getAffectedEntities(AnonymizeUserService.AnonymizeProcessData anonymizationData) {
        return new ServiceOutcomeWithWarnings<ImmutableList>(ImmutableList.of(), new HashMap<String, ErrorCollection>());
    }

    @Override
    @Nonnull
    public AnonymizeUserService.AnonymizeOperation getAnonymizeOperation() {
        return AnonymizeUserService.AnonymizeOperation.USER_DISABLE;
    }

    @Override
    public int getNumberOfTasks(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult) {
        if (!validationResult.isValid()) {
            return 0;
        }
        AnonymizeUserService.AnonymizeProcessData processData = validationResult.getProcessData();
        if (!this.shouldDeactivateUser(processData)) {
            return 0;
        }
        return 1;
    }
}

