/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.operations;

import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.user.anonymize.ServiceOutcomeWithWarnings;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.anonymize.UserPropertyChangeService;
import com.atlassian.jira.user.anonymize.key.UserKeyChangeService;
import com.atlassian.jira.user.anonymize.operations.AnonymizeOperationStep;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserKeyChangeOperationStep
implements AnonymizeOperationStep {
    private static final Logger log = LoggerFactory.getLogger(UserKeyChangeOperationStep.class);
    private final UserKeyChangeService userKeyChangeService;

    public UserKeyChangeOperationStep(UserKeyChangeService userKeyChangeService) {
        this.userKeyChangeService = userKeyChangeService;
    }

    @Nonnull
    public Optional<AnonymizeUserService.SingleOperationReport<Void>> performOperation(@Nonnull AnonymizeUserService.OperationsReport anonymizeReport, @Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult, @Nonnull Context asyncTaskContext) {
        AnonymizeUserService.AnonymizeProcessData validationResultData = validationResult.getProcessData();
        if (this.shouldPerformOperation(validationResultData)) {
            UserPropertyChangeParameter userKeyChangeParameter = new UserPropertyChangeParameter(validationResultData.getUser().getKey(), validationResultData.getNewUserKey(), asyncTaskContext);
            log.info("Changing user key for {}", (Object)userKeyChangeParameter);
            UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter> keyChangeValidationResult = this.userKeyChangeService.validateUserPropertyChange(new UserPropertyChangeService.UserPropertyChangeRequest<UserPropertyChangeParameter>(validationResult.getRequest().getExecutor(), userKeyChangeParameter));
            if (!keyChangeValidationResult.isValid()) {
                return Optional.of(new AnonymizeUserService.SingleOperationReport<Object>(AnonymizeUserService.AnonymizeOperation.USER_KEY_CHANGE, new ServiceOutcomeWithWarnings<Object>(null, keyChangeValidationResult.getErrorCollection(), new HashMap<String, ErrorCollection>())));
            }
            ServiceResult operationResult = this.userKeyChangeService.userPropertyChange(keyChangeValidationResult);
            return Optional.of(new AnonymizeUserService.SingleOperationReport<Object>(AnonymizeUserService.AnonymizeOperation.USER_KEY_CHANGE, new ServiceOutcomeWithWarnings<Object>(null, operationResult.getErrorCollection(), new HashMap<String, ErrorCollection>())));
        }
        log.warn("Wanted to perform operation but parameters are invalid. Skipping changing user key");
        return Optional.empty();
    }

    private boolean shouldPerformOperation(AnonymizeUserService.AnonymizeProcessData validationResultData) {
        return validationResultData != null && validationResultData.handleOperation(AnonymizeUserService.AnonymizeOperation.USER_KEY_CHANGE);
    }

    @Override
    @Nonnull
    public ServiceResult validate(@Nonnull AnonymizeUserService.AnonymizeProcessData anonymizationProcessData, I18nHelper i18nHelper, boolean preValidate) {
        if (StringUtils.isBlank((CharSequence)anonymizationProcessData.getNewUserKey())) {
            return ServiceOutcomeImpl.error(i18nHelper.getText("admin.errors.user.anonymize.no.new.userkey"));
        }
        AnonymizeUserService.AnonymizeUserRequest request = anonymizationProcessData.getAnonymizeUserRequest();
        UserPropertyChangeParameter userKeyChangeParameter = new UserPropertyChangeParameter(request.getUserKey(), anonymizationProcessData.getNewUserKey(), Contexts.nullContext());
        log.info("Validating changing user key {}", (Object)userKeyChangeParameter);
        return this.userKeyChangeService.validateUserPropertyChange(new UserPropertyChangeService.UserPropertyChangeRequest<UserPropertyChangeParameter>(request.getExecutor(), userKeyChangeParameter));
    }

    @Override
    @Nonnull
    public ServiceOutcomeWithWarnings<Collection<AffectedEntity>> getAffectedEntities(AnonymizeUserService.AnonymizeProcessData anonymizationData) {
        return new ServiceOutcomeWithWarnings<ImmutableList>(ImmutableList.of(), new HashMap<String, ErrorCollection>());
    }

    @Override
    @Nonnull
    public AnonymizeUserService.AnonymizeOperation getAnonymizeOperation() {
        return AnonymizeUserService.AnonymizeOperation.USER_KEY_CHANGE;
    }

    @Override
    public int getNumberOfTasks(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult) {
        if (!validationResult.isValid()) {
            return 0;
        }
        if (!this.shouldPerformOperation(validationResult.getProcessData())) {
            return 0;
        }
        return 1;
    }
}

