/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.operations;

import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.user.anonymize.ServiceOutcomeWithWarnings;
import com.atlassian.jira.user.anonymize.ServiceResultWithWarnings;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.anonymize.UserPropertyChangeService;
import com.atlassian.jira.user.anonymize.key.UserKeyChangeService;
import com.atlassian.jira.user.anonymize.operations.AnonymizeOperationStep;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserKeyChangePluginPointsOperationStep
implements AnonymizeOperationStep {
    private static final Logger log = LoggerFactory.getLogger(UserKeyChangePluginPointsOperationStep.class);
    private final UserKeyChangeService userKeyChangeService;

    public UserKeyChangePluginPointsOperationStep(UserKeyChangeService userKeyChangeService) {
        this.userKeyChangeService = userKeyChangeService;
    }

    @Override
    public Optional<AnonymizeUserService.SingleOperationReport<Void>> performOperation(@Nonnull AnonymizeUserService.OperationsReport<Void> anonymizeReport, @Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult, @Nonnull Context asyncTaskContext) {
        AnonymizeUserService.AnonymizeProcessData anonymizationProcessData = validationResult.getProcessData();
        Optional<UserPropertyChangeParameter> userKeyChangeParameterOptional = this.getUserKeyChangeParameterForProcessData(anonymizationProcessData, asyncTaskContext);
        if (!userKeyChangeParameterOptional.isPresent()) {
            log.warn("No parameter present. Skipping changing user key in extension points");
            return Optional.empty();
        }
        Optional<AnonymizeUserService.SingleOperationReport<Void>> changeUserKeyReport = anonymizeReport.getReport(AnonymizeUserService.AnonymizeOperation.USER_KEY_CHANGE);
        if (changeUserKeyReport.isPresent() && !changeUserKeyReport.get().isValid()) {
            log.info("Skipping changing user key in extension points - user key change operation failed, no need to call extension points");
            return Optional.empty();
        }
        UserPropertyChangeParameter userKeyChangeParameter = userKeyChangeParameterOptional.get();
        log.info("Changing user key in extension points for {}", (Object)userKeyChangeParameter);
        UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter> keyChangeValidationResult = this.userKeyChangeService.validateUserPropertyChangeInOtherEntities(new UserPropertyChangeService.UserPropertyChangeRequest<UserPropertyChangeParameter>(validationResult.getRequest().getExecutor(), userKeyChangeParameter));
        if (!keyChangeValidationResult.isValid()) {
            return Optional.of(new AnonymizeUserService.SingleOperationReport<Object>(AnonymizeUserService.AnonymizeOperation.USER_KEY_CHANGE_PLUGIN_POINTS, new ServiceOutcomeWithWarnings<Object>(null, keyChangeValidationResult.getErrorCollection(), new HashMap<String, ErrorCollection>())));
        }
        ServiceResultWithWarnings operationResult = this.userKeyChangeService.userPropertyChangeInOtherEntities(keyChangeValidationResult);
        return Optional.of(new AnonymizeUserService.SingleOperationReport<Object>(AnonymizeUserService.AnonymizeOperation.USER_KEY_CHANGE_PLUGIN_POINTS, new ServiceOutcomeWithWarnings<Object>(null, operationResult.getErrorCollection(), operationResult.getWarnings())));
    }

    @Override
    @Nonnull
    public ServiceOutcomeWithWarnings<Collection<AffectedEntity>> getAffectedEntities(AnonymizeUserService.AnonymizeProcessData anonymizationData) {
        UserPropertyChangeParameter parameter = this.getUserKeyChangeParameterForAffectedEntities(anonymizationData);
        log.info("Getting key change affected entities for {}", (Object)parameter);
        AnonymizeUserService.AnonymizeUserRequest request = anonymizationData.getAnonymizeUserRequest();
        return this.userKeyChangeService.getAffectedEntities(new UserPropertyChangeService.UserPropertyChangeRequest<UserPropertyChangeParameter>(request.getExecutor(), parameter));
    }

    @Override
    @Nonnull
    public AnonymizeUserService.AnonymizeOperation getAnonymizeOperation() {
        return AnonymizeUserService.AnonymizeOperation.USER_KEY_CHANGE_PLUGIN_POINTS;
    }

    @Override
    @Nonnull
    public ServiceResult validate(@Nonnull AnonymizeUserService.AnonymizeProcessData anonymizationProcessData, I18nHelper i18nHelper, boolean preValidate) {
        if (preValidate) {
            return ServiceOutcomeImpl.ok(null);
        }
        AnonymizeUserService.AnonymizeUserRequest request = anonymizationProcessData.getAnonymizeUserRequest();
        if (anonymizationProcessData.isUserKeyAlreadyAnonymized()) {
            if (request.isRerunPluginPoints()) {
                if (StringUtils.isBlank((CharSequence)request.getOldUserKey())) {
                    return ServiceOutcomeImpl.error(i18nHelper.getText("admin.errors.user.anonymize.no.old.userkey"));
                }
                return this.userKeyChangeService.validateUserPropertyChangeInOtherEntities(new UserPropertyChangeService.UserPropertyChangeRequest<UserPropertyChangeParameter>(request.getExecutor(), new UserPropertyChangeParameter(StringUtils.defaultString((String)request.getOldUserKey()), StringUtils.defaultString((String)request.getUserKey()), Contexts.nullContext())));
            }
            return ServiceOutcomeImpl.ok(null);
        }
        if (StringUtils.isBlank((CharSequence)anonymizationProcessData.getNewUserKey())) {
            return ServiceOutcomeImpl.error(i18nHelper.getText("admin.errors.user.anonymize.no.new.userkey"));
        }
        return this.userKeyChangeService.validateUserPropertyChangeInOtherEntities(new UserPropertyChangeService.UserPropertyChangeRequest<UserPropertyChangeParameter>(request.getExecutor(), new UserPropertyChangeParameter(StringUtils.defaultString((String)request.getUserKey()), StringUtils.defaultString((String)anonymizationProcessData.getNewUserKey()), Contexts.nullContext())));
    }

    @Override
    public int getNumberOfTasks(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult) {
        if (!validationResult.isValid()) {
            return 0;
        }
        Optional<UserPropertyChangeParameter> userKeyChangeParameterOptional = this.getUserKeyChangeParameterForProcessData(validationResult.getProcessData(), Contexts.nullContext());
        return userKeyChangeParameterOptional.map(this.userKeyChangeService::getNumberOfTasks).orElse(0);
    }

    @Nonnull
    private Optional<UserPropertyChangeParameter> getUserKeyChangeParameterForProcessData(@Nullable AnonymizeUserService.AnonymizeProcessData anonymizationProcessData, @Nonnull Context asyncTaskContext) {
        if (anonymizationProcessData == null || anonymizationProcessData.getUser() == null) {
            return Optional.empty();
        }
        AnonymizeUserService.AnonymizeUserRequest request = anonymizationProcessData.getAnonymizeUserRequest();
        if (anonymizationProcessData.isUserKeyAlreadyAnonymized()) {
            if (request.isRerunPluginPoints() && !StringUtils.isBlank((CharSequence)request.getOldUserKey())) {
                return Optional.of(new UserPropertyChangeParameter(request.getOldUserKey(), anonymizationProcessData.getUser().getKey(), asyncTaskContext));
            }
        } else if (!StringUtils.isBlank((CharSequence)anonymizationProcessData.getNewUserKey())) {
            return Optional.of(new UserPropertyChangeParameter(anonymizationProcessData.getUser().getKey(), anonymizationProcessData.getNewUserKey(), asyncTaskContext));
        }
        return Optional.empty();
    }

    @Nonnull
    private UserPropertyChangeParameter getUserKeyChangeParameterForAffectedEntities(AnonymizeUserService.AnonymizeProcessData anonymizationProcessData) {
        return this.getUserKeyChangeParameterForProcessData(anonymizationProcessData, Contexts.nullContext()).orElseGet(() -> new UserPropertyChangeParameter(anonymizationProcessData.getAnonymizeUserRequest().getUserKey(), anonymizationProcessData.getAnonymizeUserRequest().getUserKey(), Contexts.nullContext()));
    }
}

