/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.anonymize.operations;

import com.atlassian.jira.bc.ServiceOutcomeImpl;
import com.atlassian.jira.bc.ServiceResult;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.task.context.Contexts;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.anonymize.AffectedEntity;
import com.atlassian.jira.user.anonymize.AnonymizeUserService;
import com.atlassian.jira.user.anonymize.ServiceOutcomeWithWarnings;
import com.atlassian.jira.user.anonymize.UserPropertyChangeParameter;
import com.atlassian.jira.user.anonymize.UserPropertyChangeService;
import com.atlassian.jira.user.anonymize.name.UserNameChangeService;
import com.atlassian.jira.user.anonymize.operations.AnonymizeOperationStep;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.I18nHelper;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserNameChangeOperationStep
implements AnonymizeOperationStep {
    private static final Logger log = LoggerFactory.getLogger(UserNameChangeOperationStep.class);
    private final UserKeyService userKeyService;
    private final UserNameChangeService userNameChangeService;

    public UserNameChangeOperationStep(UserKeyService userKeyService, UserNameChangeService userNameChangeService) {
        this.userKeyService = userKeyService;
        this.userNameChangeService = userNameChangeService;
    }

    @Nonnull
    public Optional<AnonymizeUserService.SingleOperationReport<Void>> performOperation(@Nonnull AnonymizeUserService.OperationsReport anonymizeReport, @Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult, @Nonnull Context asyncTaskContext) {
        AnonymizeUserService.AnonymizeProcessData validationResultData = validationResult.getProcessData();
        if (this.shouldHandleOperation(validationResultData)) {
            String originalUserName = validationResultData.getUser().getUsername();
            UserPropertyChangeParameter userNameChangeParameter = new UserPropertyChangeParameter(originalUserName, validationResultData.getNewUserName(), asyncTaskContext);
            log.info("Changing username {}", (Object)originalUserName);
            UserPropertyChangeService.UserPropertyChangeValidationResult<UserPropertyChangeParameter> nameChangeValidationResult = this.userNameChangeService.validateUserPropertyChange(new UserPropertyChangeService.UserPropertyChangeRequest<UserPropertyChangeParameter>(validationResult.getRequest().getExecutor(), userNameChangeParameter));
            if (!nameChangeValidationResult.isValid()) {
                return Optional.of(new AnonymizeUserService.SingleOperationReport<Object>(AnonymizeUserService.AnonymizeOperation.USER_NAME_CHANGE, new ServiceOutcomeWithWarnings<Object>(null, nameChangeValidationResult.getErrorCollection(), new HashMap<String, ErrorCollection>())));
            }
            ServiceResult operationResult = this.userNameChangeService.userPropertyChange(nameChangeValidationResult);
            return Optional.of(new AnonymizeUserService.SingleOperationReport<Object>(AnonymizeUserService.AnonymizeOperation.USER_NAME_CHANGE, new ServiceOutcomeWithWarnings<Object>(null, operationResult.getErrorCollection(), new HashMap<String, ErrorCollection>())));
        }
        log.warn("Wanted to perform operation but parameters are invalid. Skipping changing username");
        return Optional.empty();
    }

    private boolean shouldHandleOperation(AnonymizeUserService.AnonymizeProcessData validationResultData) {
        return validationResultData != null && validationResultData.handleOperation(AnonymizeUserService.AnonymizeOperation.USER_NAME_CHANGE);
    }

    @Override
    @Nonnull
    public ServiceResult validate(@Nonnull AnonymizeUserService.AnonymizeProcessData anonymizationProcessData, I18nHelper i18nBean, boolean preValidate) {
        if (StringUtils.isBlank((CharSequence)anonymizationProcessData.getNewUserName())) {
            return ServiceOutcomeImpl.error(i18nBean.getText("admin.errors.user.anonymize.no.new.username"));
        }
        AnonymizeUserService.AnonymizeUserRequest request = anonymizationProcessData.getAnonymizeUserRequest();
        UserPropertyChangeParameter userNameChangeParameter = new UserPropertyChangeParameter(this.userKeyService.getUsernameForKey(request.getUserKey()), anonymizationProcessData.getNewUserName(), Contexts.nullContext());
        log.info("Validating changing user name for {}", (Object)userNameChangeParameter);
        return this.userNameChangeService.validateUserPropertyChange(new UserPropertyChangeService.UserPropertyChangeRequest<UserPropertyChangeParameter>(request.getExecutor(), userNameChangeParameter));
    }

    @Override
    @Nonnull
    public ServiceOutcomeWithWarnings<Collection<AffectedEntity>> getAffectedEntities(AnonymizeUserService.AnonymizeProcessData anonymizationData) {
        return new ServiceOutcomeWithWarnings<ImmutableList>(ImmutableList.of(), new HashMap<String, ErrorCollection>());
    }

    @Override
    @Nonnull
    public AnonymizeUserService.AnonymizeOperation getAnonymizeOperation() {
        return AnonymizeUserService.AnonymizeOperation.USER_NAME_CHANGE;
    }

    @Override
    public int getNumberOfTasks(@Nonnull AnonymizeUserService.AnonymizeValidationResult validationResult) {
        if (!validationResult.isValid()) {
            return 0;
        }
        if (!this.shouldHandleOperation(validationResult.getProcessData())) {
            return 0;
        }
        return 1;
    }
}

