/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.user.util;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.recovery.RecoveryModeService;
import com.atlassian.jira.util.dbc.Assertions;
import io.atlassian.util.concurrent.LazyReference;

public final class CachingRecoveryModeService
implements RecoveryModeService {
    private final RecoveryModeService delegate;
    private final LazyReference<State> state = new LazyReference<State>(){

        protected State create() throws Exception {
            return new State(CachingRecoveryModeService.this.delegate);
        }
    };

    public CachingRecoveryModeService(RecoveryModeService delegate) {
        this.delegate = (RecoveryModeService)Assertions.notNull((String)"delegate", (Object)delegate);
    }

    public boolean isRecoveryModeOn() {
        return ((State)this.state.get()).isEnabled();
    }

    public Directory getRecoveryDirectory() {
        return ((State)this.state.get()).getDirectory();
    }

    public String getRecoveryUsername() {
        return ((State)this.state.get()).getUserName();
    }

    private static class State {
        private final boolean enabled;
        private final Directory directory;
        private final String userName;

        private State(RecoveryModeService service) {
            this.enabled = service.isRecoveryModeOn();
            if (this.enabled) {
                this.directory = service.getRecoveryDirectory();
                this.userName = service.getRecoveryUsername();
            } else {
                this.directory = null;
                this.userName = null;
            }
        }

        private boolean isEnabled() {
            return this.enabled;
        }

        private Directory getDirectory() {
            this.assertEnabled();
            return this.directory;
        }

        private String getUserName() {
            this.assertEnabled();
            return this.userName;
        }

        private void assertEnabled() {
            if (!this.isEnabled()) {
                throw new IllegalStateException("Recovery Mode is not enabled.");
            }
        }
    }
}

