/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util;

import com.atlassian.jira.util.LuceneDirectoryUtils;
import com.atlassian.jira.util.RuntimeIOException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;

public class LuceneDirectoryUtilsImpl
implements LuceneDirectoryUtils {
    private static final ConcurrentMap<Path, IndexDeletionPolicy> indexDeletionPolicies = new ConcurrentHashMap<Path, IndexDeletionPolicy>();

    @Override
    public Directory getDirectory(File path) {
        try {
            return FSDirectory.open((Path)path.toPath());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @Override
    public IndexDeletionPolicy getDeletionPolicy(Directory directory) {
        if (directory instanceof FSDirectory) {
            return indexDeletionPolicies.computeIfAbsent(((FSDirectory)directory).getDirectory().toAbsolutePath(), d -> new SnapshotDeletionPolicy((IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy()));
        }
        return new KeepOnlyLastCommitDeletionPolicy();
    }
}

