/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.collect;

import com.atlassian.jira.util.Function;
import com.atlassian.jira.util.Supplier;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.collect.CompositeMap;
import com.atlassian.jira.util.collect.LazyMapEntry;
import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class MemoizingMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V> {
    private final Map<K, Supplier<? extends V>> master;
    private final Map<K, V> cache = new HashMap();

    MemoizingMap(Map<K, Supplier<? extends V>> underlying) {
        this.master = underlying;
    }

    @Override
    public V get(Object key) {
        Object value = this.cache.get(key);
        if (value == null) {
            Supplier<? extends V> supplier = this.master.get(key);
            if (supplier == null) {
                return null;
            }
            value = supplier.get();
            Object k = key;
            this.cache.put(k, value);
        }
        return value;
    }

    @Override
    public Set<K> keySet() {
        return this.master.keySet();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return CollectionUtil.transformSet(this.keySet(), (Function)new EntryTransformer());
    }

    @Override
    public int size() {
        return this.master.size();
    }

    @Override
    public boolean isEmpty() {
        return this.master.isEmpty();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    static class ReferenceSupplier<T>
    implements Supplier<T> {
        private final T ref;

        public ReferenceSupplier(T ref) {
            this.ref = ref;
        }

        public T get() {
            return this.ref;
        }
    }

    public static class Master<K, V> {
        private final Map<K, Supplier<? extends V>> suppliers;

        public static <K, V> Builder<K, V> builder() {
            return new Builder();
        }

        Master(Map<K, Supplier<? extends V>> suppliers) {
            this.suppliers = suppliers;
        }

        public Master<K, V> combine(Master<K, V> other) {
            return new Master<K, V>(CompositeMap.of(other.suppliers, this.suppliers));
        }

        public Map<K, V> toMap(Map<K, ? extends V> localValues) {
            Map<K, ? extends V> map = localValues;
            return CompositeMap.of(map, new MemoizingMap<K, V>(this.suppliers));
        }

        public static class Builder<K, V> {
            private final Map<K, Supplier<? extends V>> suppliers = new HashMap<K, Supplier<? extends V>>();

            Builder() {
            }

            public Builder<K, V> addLazy(K key, Supplier<? extends V> value) {
                this.suppliers.put(key, value);
                return this;
            }

            public Builder<K, V> add(K key, V value) {
                this.suppliers.put(key, new ReferenceSupplier<V>(value));
                return this;
            }

            public Master<K, V> master() {
                return new Master(ImmutableMap.copyOf(this.suppliers));
            }
        }
    }

    class EntryTransformer
    implements Function<K, Map.Entry<K, V>> {
        EntryTransformer() {
        }

        public Map.Entry<K, V> apply(K key) {
            return new LazyMapEntry((Map)MemoizingMap.this, key);
        }
    }
}

