/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.compression;

import com.atlassian.jira.util.RuntimeIOException;
import com.atlassian.jira.util.compression.ArchiveCompressor;
import com.atlassian.jira.util.compression.SnappyArchiveCompressor;
import com.atlassian.jira.util.compression.SnappyArchiveDecompressor;
import com.atlassian.jira.util.compression.TarArchiveCompressor;
import com.atlassian.jira.util.compression.TarArchiveDecompressor;
import com.atlassian.jira.util.compression.ZipArchiveCompressor;
import com.atlassian.jira.util.compression.ZipArchiveDecompressor;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.compress.archivers.ArchiveException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveUtils {
    private static final Logger log = LoggerFactory.getLogger(ArchiveUtils.class);

    public static ArchiveCompressor createArchiveCompressor(File file, Type type) {
        log.info("Creating archive of type: {} in path: {}", (Object)type, (Object)file.getPath());
        try {
            switch (type) {
                case SNAPPY: {
                    return new SnappyArchiveCompressor(file);
                }
                case TAR: {
                    return new TarArchiveCompressor(file);
                }
                case ZIP: {
                    return new ZipArchiveCompressor(file);
                }
            }
            throw new IllegalStateException("Unknown archive type: " + (Object)((Object)type));
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
        catch (ArchiveException e) {
            throw new RuntimeException(e);
        }
    }

    public static ArchiveCompressor createArchiveCompressor(File file) {
        Type type = ArchiveUtils.getTypeForFile(file);
        return ArchiveUtils.createArchiveCompressor(file, type);
    }

    public static void decompress(File input, Type type, File outputDir) throws IOException {
        switch (type) {
            case SNAPPY: {
                new SnappyArchiveDecompressor().decompress(input, outputDir);
                break;
            }
            case TAR: {
                new TarArchiveDecompressor().decompress(input, outputDir);
                break;
            }
            case ZIP: {
                new ZipArchiveDecompressor().decompress(input, outputDir);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown archive type: " + (Object)((Object)type));
            }
        }
    }

    public static void decompress(File input, File outputDir) throws IOException {
        Type type = ArchiveUtils.getTypeForFile(input);
        ArchiveUtils.decompress(input, type, outputDir);
    }

    static Type getTypeForFile(File file) {
        String filename = file.getName();
        for (Type type : Type.values()) {
            if (!filename.endsWith(type.extension)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown archive format: " + file.getName());
    }

    private ArchiveUtils() {
    }

    public static enum Type {
        SNAPPY(".tar.sz"),
        TAR(".tar"),
        ZIP(".zip");

        final String extension;

        private Type(String extension) {
            this.extension = extension;
        }

        public static Type fromName(String name) {
            return Type.valueOf(name.toUpperCase(Locale.ENGLISH));
        }

        public String getExtension() {
            return this.extension;
        }
    }
}

