/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.performance;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.log4j.Logger;

public class ExecutionTimeHelper {
    private static final Logger log = Logger.getLogger(ExecutionTimeHelper.class);

    public static <T> T measureExecutionTime(String measurementName, Supplier<T> supplier) {
        return ExecutionTimeHelper.measureExecutionTime(measurementName, TimeUnit.MICROSECONDS, supplier);
    }

    public static <T> T measureAvrgExecutionTime(String measurementName, Supplier<T> supplier) {
        return ExecutionTimeHelper.measureAvrgExecutionTime(measurementName, 100, TimeUnit.MICROSECONDS, supplier);
    }

    public static <T> T measureExecutionTime(String measurementName, TimeUnit timeUnit, Supplier<T> supplier) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        T result = supplier.get();
        stopwatch.stop();
        log.info((Object)("Method execution time measurement named: '" + measurementName + "' took: " + stopwatch.elapsed(timeUnit) + " " + ExecutionTimeHelper.abbreviate(timeUnit)));
        return result;
    }

    public static <T> T measureAvrgExecutionTime(String measurementName, int numberOfRuns, TimeUnit timeUnit, Supplier<T> supplier) {
        ArrayList results = Lists.newArrayListWithCapacity((int)10);
        Stopwatch stopwatch = Stopwatch.createStarted();
        for (int i = 0; i < numberOfRuns; ++i) {
            results.add(i % 10, supplier.get());
        }
        stopwatch.stop();
        log.info((Object)("Method execution time measurement named: '" + measurementName + "' took: " + (double)stopwatch.elapsed(timeUnit) / (double)numberOfRuns + " " + ExecutionTimeHelper.abbreviate(timeUnit)));
        return (T)results.get(0);
    }

    private static String abbreviate(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "?s";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
        }
        return unit.name();
    }
}

