/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.system.check;

public class JvmVersionUtil {
    public static final String JAVA_VERSION_6 = "1.6.0";
    public static final String JAVA_VERSION_5 = "1.5.0";

    public int getMajorVersion(String javaVersion) {
        String[] parts = javaVersion.split("\\.");
        return parts.length >= 2 ? this.parse(parts[1]) : -1;
    }

    public int getMinorVersion(String javaVersion) {
        String[] parts;
        int jvmMinorVersion = javaVersion.indexOf("_") == -1 ? 0 : ((parts = javaVersion.split("[-_]")).length >= 2 ? this.parse(parts[1]) : -1);
        return jvmMinorVersion;
    }

    public int getBuildNumber(String javaVersion) {
        String[] parts;
        int build = javaVersion.indexOf("-") == -1 ? 0 : ((parts = javaVersion.split("[-_]")).length >= 3 ? this.parse(parts[2].substring(1)) : -1);
        return build;
    }

    private int parse(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

