/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.jira.application.ApplicationRoleManager;
import com.atlassian.jira.permission.GlobalPermissionKey;
import com.atlassian.jira.permission.GlobalPermissionType;
import com.atlassian.jira.security.GlobalPermissionEntry;
import com.atlassian.jira.security.GlobalPermissionManager;
import com.atlassian.jira.security.groups.GroupManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.GlobalPermissionGroupAssociationUtil;
import com.atlassian.jira.web.action.ProjectActionSupport;
import com.atlassian.jira.web.util.ExternalLinkUtil;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Maps;
import io.atlassian.fugue.Option;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
public class GlobalPermissions
extends ProjectActionSupport {
    private static final String EXTERNAL_LINK_GLOBAL_PERMISSIONS_MANAGEMENT = "external.link.global.permissions.management";
    private Map<String, String> globalPermTypes;
    private String groupName;
    private String globalPermTypeName = "";
    private String action = "view";
    private final GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil;
    private final GlobalPermissionManager globalPermissionManager;
    private final GroupManager groupManager;
    private final ApplicationRoleManager applicationRoleManager;
    private final ExternalLinkUtil externalLinkUtil;
    private final Supplier<String> returnUnknownString = () -> this.getText("common.words.unknown");

    public GlobalPermissions(GlobalPermissionManager globalPermissionManager, GlobalPermissionGroupAssociationUtil globalPermissionGroupAssociationUtil, GroupManager groupManager, ApplicationRoleManager applicationRoleManager, ExternalLinkUtil externalLinkUtil) {
        this.globalPermissionGroupAssociationUtil = globalPermissionGroupAssociationUtil;
        this.globalPermissionManager = globalPermissionManager;
        this.groupManager = groupManager;
        this.applicationRoleManager = applicationRoleManager;
        this.externalLinkUtil = externalLinkUtil;
    }

    public String doDefault() throws Exception {
        return "success";
    }

    public void doValidation() {
        if (StringUtils.isNotBlank((CharSequence)this.globalPermTypeName) && this.groupName != null) {
            Group group;
            Option globalPermissionOpt = this.globalPermissionManager.getGlobalPermission(this.globalPermTypeName);
            Group group2 = group = this.isAnonymous() ? null : this.groupManager.getGroup(this.groupName);
            if (globalPermissionOpt.isEmpty()) {
                this.addError("globalPermType", this.getText("admin.errors.permissions.inexistent.permission"));
            } else {
                if (!(this.isAnonymous() || group != null || "del".equals(this.action) || "confirm".equals(this.action))) {
                    this.addError("groupName", this.getText("admin.errors.permissions.inexistent.group", "'" + this.groupName + "'"));
                }
                GlobalPermissionType globalPermissionType = (GlobalPermissionType)globalPermissionOpt.get();
                this.validateAdd(group, globalPermissionType);
                this.validateDelete(globalPermissionType);
            }
        } else if ("add".equals(this.action)) {
            if (StringUtils.isBlank((CharSequence)this.globalPermTypeName)) {
                this.addError("globalPermType", this.getText("admin.errors.permissions.must.select.permission"));
            }
            if (this.groupName == null) {
                this.addError("groupName", this.getText("admin.errors.permissions.must.select.group"));
            }
        }
        super.doValidation();
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        Option globalPermissionOpt;
        if (StringUtils.isNotBlank((CharSequence)this.globalPermTypeName) && this.groupName != null && (globalPermissionOpt = this.globalPermissionManager.getGlobalPermission(this.globalPermTypeName)).isDefined()) {
            GlobalPermissionType globalPermissionType = (GlobalPermissionType)globalPermissionOpt.get();
            if ("del".equals(this.action)) {
                this.removePermission(globalPermissionType, this.groupName);
                this.action = "view";
                return this.getPermissionRedirect();
            }
            if ("confirm".equals(this.action)) {
                return "confirm";
            }
            if ("add".equals(this.action)) {
                Group group = this.isAnonymous() ? null : this.groupManager.getGroup(this.groupName);
                this.addPermission(globalPermissionType, group);
                return this.getPermissionRedirect();
            }
        }
        return this.getResult();
    }

    private void validateDelete(GlobalPermissionType globalPermissionType) {
        Collection groupNames;
        if (!"del".equals(this.action) && !"confirm".equals(this.action)) {
            return;
        }
        if (!this.isAnonymous() && !(groupNames = this.globalPermissionManager.getGroupNamesWithPermission(globalPermissionType.getGlobalPermissionKey())).contains(this.groupName)) {
            this.addErrorMessage(this.getText("admin.errors.permissions.delete.group.not.in.permission", this.groupName, this.getText(globalPermissionType.getNameI18nKey())));
        }
        if (!this.isManagedByJira(this.globalPermTypeName)) {
            this.addErrorMessage(this.getText("admin.errors.permissions.permission.not.managed.by.jira"));
        }
        if (this.globalPermTypeName.equals(GlobalPermissionKey.ADMINISTER.getKey())) {
            boolean removingAllPerms;
            boolean bl = removingAllPerms = this.globalPermissionGroupAssociationUtil.isRemovingAllMyAdminGroups(Arrays.asList(this.isAnonymous() ? null : this.groupName), this.getLoggedInUser()) && !this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, this.getLoggedInUser());
            if (removingAllPerms) {
                this.addErrorMessage(this.getText("admin.errors.permissions.no.permission"));
            }
        } else if (this.globalPermTypeName.equals(GlobalPermissionKey.SYSTEM_ADMIN.getKey())) {
            if (!this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, this.getLoggedInUser())) {
                this.addErrorMessage(this.getText("admin.errors.permissions.no.permission.sys.admin.only"));
            } else {
                String[] stringArray = new String[1];
                String string = stringArray[0] = this.isAnonymous() ? null : this.groupName;
                if (this.globalPermissionGroupAssociationUtil.isRemovingAllMySysAdminGroups(Arrays.asList(stringArray), this.getLoggedInUser())) {
                    this.addErrorMessage(this.getText("admin.errors.permissions.no.permission.sys.admin"));
                }
            }
        }
    }

    private void validateAdd(@Nullable Group group, GlobalPermissionType globalPermissionType) {
        if (!"add".equals(this.action)) {
            return;
        }
        if (this.isAnonymous()) {
            if (!globalPermissionType.isAnonymousAllowed()) {
                this.addError("groupName", this.getText("admin.errors.permissions.group.notallowed.for.permission", this.getText("admin.common.words.anyone"), this.getText(globalPermissionType.getNameI18nKey())));
            }
        } else if (group != null && this.globalPermTypeName.equals(GlobalPermissionKey.USE.getKey()) && this.getAdministrativeGroups().contains(group)) {
            this.addError("groupName", this.getText("admin.errors.permissions.group.notallowed.for.permission", this.groupName, this.getText(globalPermissionType.getNameI18nKey())));
        }
        if (!this.getGlobalPermTypes().containsKey(this.globalPermTypeName)) {
            this.addErrorMessage(this.getText("admin.errors.permissions.not.have.permission.to.add"));
        } else if (!this.isManagedByJira(this.globalPermTypeName)) {
            this.addErrorMessage(this.getText("admin.errors.permissions.permission.not.managed.by.jira"));
        }
    }

    private boolean isAnonymous() {
        return "".equals(this.groupName);
    }

    private String getPermissionRedirect() throws Exception {
        return this.getRedirect("GlobalPermissions!default.jspa");
    }

    private void addPermission(GlobalPermissionType globalPermissionType, Group group) {
        String groupName;
        String string = groupName = group == null ? null : group.getName();
        if (!this.globalPermissionManager.getGroupNamesWithPermission(globalPermissionType.getGlobalPermissionKey()).contains(groupName)) {
            this.globalPermissionManager.addPermission(globalPermissionType, groupName);
        }
    }

    private void removePermission(GlobalPermissionType globalPermissionType, String groupName) {
        Group group = this.isAnonymous() ? null : this.groupManager.getGroup(groupName);
        String groupToDelete = null;
        if (group != null) {
            groupToDelete = group.getName();
        } else if (!this.isAnonymous()) {
            groupToDelete = groupName;
        }
        this.globalPermissionManager.removePermission(globalPermissionType, groupToDelete);
    }

    public Collection<GlobalPermissionEntry> getPermissionGroups(String globalPermType) {
        return this.globalPermissionManager.getPermissions(GlobalPermissionKey.of((String)globalPermType));
    }

    public Collection getGroups() {
        return this.groupManager.getAllGroups();
    }

    public String getGlobalPermType() {
        return this.globalPermTypeName;
    }

    public String getPermTypeName() {
        return (String)this.globalPermissionManager.getGlobalPermission(this.globalPermTypeName).fold(this.returnUnknownString, globalPermissionType -> this.getText(globalPermissionType.getNameI18nKey()));
    }

    public void setGlobalPermType(String globalPermType) {
        this.globalPermTypeName = globalPermType;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName.trim();
    }

    public void setAction(String action) {
        this.action = "del".equalsIgnoreCase(action) || "delete".equalsIgnoreCase(action) ? "del" : ("confirm".equalsIgnoreCase(action) ? "confirm" : "add");
    }

    public boolean isConfirm() {
        return "confirm".equalsIgnoreCase(this.action);
    }

    public Map<String, String> getGlobalPermTypes() {
        if (this.globalPermTypes == null) {
            this.globalPermTypes = new LinkedHashMap<String, String>();
            if (this.globalPermissionManager.hasPermission(GlobalPermissionKey.SYSTEM_ADMIN, this.getLoggedInUser())) {
                GlobalPermissionType sysAdminPermission = (GlobalPermissionType)this.globalPermissionManager.getGlobalPermission(GlobalPermissionKey.SYSTEM_ADMIN).get();
                this.globalPermTypes.put(GlobalPermissionKey.SYSTEM_ADMIN.getKey(), this.getText(sysAdminPermission.getNameI18nKey()));
            }
            this.permissionMapHelper(GlobalPermissionKey.ADMINISTER, this.globalPermTypes);
            this.permissionMapHelper(GlobalPermissionKey.USE, this.globalPermTypes);
            this.permissionMapHelper(GlobalPermissionKey.USER_PICKER, this.globalPermTypes);
            this.permissionMapHelper(GlobalPermissionKey.CREATE_SHARED_OBJECTS, this.globalPermTypes);
            this.permissionMapHelper(GlobalPermissionKey.MANAGE_GROUP_FILTER_SUBSCRIPTIONS, this.globalPermTypes);
            this.permissionMapHelper(GlobalPermissionKey.BULK_CHANGE, this.globalPermTypes);
            this.globalPermissionManager.getAllGlobalPermissions().stream().filter(gpT -> !this.globalPermTypes.containsKey(gpT.getKey()) && !GlobalPermissionKey.SYSTEM_ADMIN.equals((Object)gpT.getGlobalPermissionKey())).forEach(gpT -> this.globalPermTypes.put(gpT.getKey(), this.getText(gpT.getNameI18nKey())));
            this.globalPermTypes.remove(GlobalPermissionKey.USE.getKey());
        }
        return this.globalPermTypes;
    }

    public Map<String, String> getManagablePermissions() {
        return Maps.filterEntries(this.getGlobalPermTypes(), entry -> this.isManagedByJira((String)entry.getKey()));
    }

    private void permissionMapHelper(GlobalPermissionKey permissionKey, Map<String, String> map) {
        Option permissionOpt = this.globalPermissionManager.getGlobalPermission(permissionKey);
        if (permissionOpt.isDefined()) {
            GlobalPermissionType permission = (GlobalPermissionType)permissionOpt.get();
            map.put(permission.getKey(), this.getText(permission.getNameI18nKey()));
        }
    }

    public String getDescription(String permType) {
        return (String)this.globalPermissionManager.getGlobalPermission(permType).fold(this.returnUnknownString, globalPermissionType -> this.getText(globalPermissionType.getDescriptionI18nKey()));
    }

    public boolean isManagedByJira(String permKey) {
        return this.globalPermissionManager.isPermissionManagedByJira(GlobalPermissionKey.of((String)permKey));
    }

    public String getExternalPermissionManagementUrl() {
        return this.externalLinkUtil.getProperty(EXTERNAL_LINK_GLOBAL_PERMISSIONS_MANAGEMENT);
    }

    public boolean hasExceededUserLimit() {
        return this.applicationRoleManager.isAnyRoleLimitExceeded();
    }

    private Collection<Group> getAdministrativeGroups() {
        ArrayList groups = new ArrayList(this.globalPermissionManager.getGroupsWithPermission(GlobalPermissionKey.ADMINISTER));
        groups.addAll(this.globalPermissionManager.getGroupsWithPermission(GlobalPermissionKey.SYSTEM_ADMIN));
        return Collections.unmodifiableCollection(groups);
    }

    private static final class Actions {
        private static final String VIEW = "view";
        private static final String ADD = "add";
        private static final String DEL = "del";
        private static final String DELETE = "delete";
        private static final String CONFIRM = "confirm";

        private Actions() {
        }
    }
}

