/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin;

import com.atlassian.jira.bc.project.ProjectAction;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.login.LoginManager;
import com.atlassian.jira.security.websudo.InternalWebSudoManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.UrlBuilder;
import com.atlassian.jira.util.velocity.VelocityRequestContext;
import com.atlassian.jira.util.velocity.VelocityRequestContextFactory;
import com.atlassian.jira.util.velocity.VelocityRequestSession;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.seraph.util.RedirectUtils;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import webwork.action.ActionContext;
import webwork.action.ServletActionContext;

public class WebSudoAuthenticate
extends JiraWebActionSupport {
    private InternalWebSudoManager webSudoManager;
    private final JiraAuthenticationContext authenticationContext;
    private final VelocityRequestContextFactory contextFactory;
    private final ProjectService projectService;
    private final ApplicationProperties applicationProperties;
    private String password;
    private String destination;
    private LoginManager loginManager;
    private Map<String, List<String>> allParams = new HashMap<String, List<String>>();
    private boolean isPost;
    private boolean close;

    public WebSudoAuthenticate(LoginManager loginManager, InternalWebSudoManager webSudoManager, JiraAuthenticationContext authenticationContext, VelocityRequestContextFactory contextFactory, ProjectService projectService, ApplicationProperties applicationProperties) {
        this.loginManager = loginManager;
        this.webSudoManager = webSudoManager;
        this.authenticationContext = authenticationContext;
        this.contextFactory = contextFactory;
        this.projectService = projectService;
        this.applicationProperties = applicationProperties;
    }

    public String doDefault() throws Exception {
        ApplicationUser loggedInUser = this.getLoggedInUser();
        HttpServletRequest request = ActionContext.getRequest();
        if (loggedInUser == null) {
            String loginUrl = RedirectUtils.getLoginUrl((HttpServletRequest)request);
            return this.getRedirect(this.stripContextPath(loginUrl, request));
        }
        this.password = null;
        this.setWebSudoIsPost(request.getMethod().equals("POST"));
        this.allParams.put("webSudoIsPost", Arrays.asList(Boolean.toString(this.getWebSudoIsPost())));
        Enumeration enumeration = request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String[] values = request.getParameterValues(name);
            this.allParams.put(name, Arrays.asList(values));
        }
        return super.doDefault();
    }

    private String stripContextPath(String loginUrl, HttpServletRequest request) {
        String contextPath = StringUtils.trimToEmpty((String)request.getContextPath());
        int index = loginUrl.indexOf(contextPath);
        if (index == 0) {
            loginUrl = loginUrl.substring(index + contextPath.length());
        }
        return loginUrl;
    }

    protected String doExecute() throws Exception {
        this.webSudoManager.startSession(ServletActionContext.getRequest(), ServletActionContext.getResponse());
        if (this.getWebSudoIsPost()) {
            Enumeration enumeration = this.request.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                if (name.toLowerCase().startsWith("websudo")) continue;
                String[] values = this.request.getParameterValues(name);
                this.allParams.put(name, Arrays.asList(values));
            }
            return "repostform";
        }
        this.setReturnUrl(null);
        if (this.isClose()) {
            return this.returnComplete(this.getWebSudoDestination());
        }
        return this.getRedirect(this.getWebSudoDestination());
    }

    public void doValidation() {
        if (StringUtils.isBlank((CharSequence)this.password)) {
            this.addError("webSudoPassword", this.getText("websudo.password.empty"));
            this.copyAllParams();
            return;
        }
        if (!this.loginManager.authenticateWithoutElevatedCheck(this.getLoggedInUser(), this.password).isOK()) {
            this.addError("webSudoPassword", this.getText("websudo.password.wrong"));
            this.copyAllParams();
        }
    }

    public String getCancelUrl() {
        VelocityRequestContext requestContext = this.contextFactory.getJiraVelocityRequestContext();
        VelocityRequestSession session = requestContext.getSession();
        String projectKey = (String)session.getAttribute("atl.jira.admin.current.project");
        String baseUrl = requestContext.getBaseUrl();
        StringBuilder url = new StringBuilder(baseUrl);
        if (StringUtils.isNotBlank((CharSequence)projectKey)) {
            ProjectService.GetProjectResult projectResult = this.projectService.getProjectByKeyForAction(this.authenticationContext.getUser(), projectKey, ProjectAction.EDIT_PROJECT_CONFIG);
            if (projectResult.isValid()) {
                url.append("/plugins/servlet/project-config");
                Project project = projectResult.getProject();
                url.append('/').append(project.getKey());
                String tab = (String)session.getAttribute("atl.jira.admin.current.project.tab");
                if (StringUtils.isNotBlank((CharSequence)tab)) {
                    url.append('/').append(tab);
                } else {
                    url.append("/summary");
                }
            } else {
                url.append("/secure/project/ViewProjects.jspa");
            }
        } else {
            url.append("/secure/project/ViewProjects.jspa");
        }
        return new UrlBuilder(url.toString(), this.applicationProperties.getEncoding(), false).asUrlString();
    }

    private void copyAllParams() {
        Enumeration enumeration = this.request.getParameterNames();
        while (enumeration.hasMoreElements()) {
            String name = (String)enumeration.nextElement();
            String[] values = this.request.getParameterValues(name);
            this.allParams.put(name, Arrays.asList(values));
        }
    }

    public String getUsername() {
        return this.getLoggedInApplicationUser().getName();
    }

    public String getWebSudoPassword() {
        return this.password;
    }

    public void setWebSudoPassword(String password) {
        this.password = password;
    }

    public String getWebSudoDestination() {
        if (StringUtils.isNotBlank((CharSequence)this.destination)) {
            return this.destination;
        }
        return "/secure/project/ViewProjects.jspa";
    }

    public void setWebSudoDestination(String destination) {
        this.destination = this.getRedirectSanitiser().makeSafeRedirectUrl(destination);
    }

    public Map<String, List<String>> getRequestParameters() {
        return this.allParams;
    }

    public boolean getWebSudoIsPost() {
        return this.isPost;
    }

    public void setWebSudoIsPost(boolean post) {
        this.isPost = post;
    }

    public boolean isClose() {
        return this.close;
    }

    public void setClose(boolean close) {
        this.close = close;
    }
}

