/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuefields.enterprise;

import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.ReindexMessageManager;
import com.atlassian.jira.config.SubTaskManager;
import com.atlassian.jira.issue.fields.ProjectFieldLayoutSchemeHelper;
import com.atlassian.jira.issue.fields.layout.field.EditableFieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayout;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutManager;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutScheme;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutSchemeEntity;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.jira.web.action.admin.issuefields.enterprise.FieldLayoutSchemeHelper;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

@WebSudoRequired
public class ConfigureFieldLayoutScheme
extends JiraWebActionSupport {
    private Long id;
    private String issueTypeId;
    private Long fieldConfigurationId;
    private final FieldLayoutManager fieldLayoutManager;
    private final ConstantsManager constantsManager;
    private final SubTaskManager subTaskManager;
    private final ReindexMessageManager reindexMessageManager;
    private final FieldLayoutSchemeHelper fieldLayoutSchemeHelper;
    private final ProjectFieldLayoutSchemeHelper helper;
    private FieldLayoutScheme fieldLayoutScheme;
    private List<IssueType> addableIssueTypes;
    private List<EditableFieldLayout> editableFieldLayouts;
    private Collection<IssueType> allRelevantIssueTypes;
    private Collection<IssueType> allRelevantIssueTypeObjects;
    private String edited;
    private List<Project> projects;

    public ConfigureFieldLayoutScheme(FieldLayoutManager fieldLayoutManager, ConstantsManager constantsManager, SubTaskManager subTaskManager, ReindexMessageManager reindexMessageManager, FieldLayoutSchemeHelper fieldLayoutSchemeHelper, ProjectFieldLayoutSchemeHelper helper) {
        this.fieldLayoutManager = fieldLayoutManager;
        this.constantsManager = constantsManager;
        this.subTaskManager = subTaskManager;
        this.reindexMessageManager = (ReindexMessageManager)Assertions.notNull((String)"reindexMessageManager", (Object)reindexMessageManager);
        this.fieldLayoutSchemeHelper = (FieldLayoutSchemeHelper)Assertions.notNull((String)"fieldLayoutSchemeHelper", (Object)fieldLayoutSchemeHelper);
        this.helper = helper;
    }

    protected void doValidation() {
        if (this.getId() == null) {
            this.addErrorMessage(this.getText("admin.errors.id.required"));
        }
    }

    protected String doExecute() throws Exception {
        return this.getResult();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Collection<FieldLayoutSchemeEntity> getFieldLayoutSchemeItems() {
        return this.getFieldLayoutScheme().getEntities();
    }

    public FieldLayout getFieldLayout(Long fieldLayoutId) {
        if (fieldLayoutId == null) {
            return this.fieldLayoutManager.getEditableDefaultFieldLayout();
        }
        return this.fieldLayoutManager.getEditableFieldLayout(fieldLayoutId);
    }

    public FieldLayoutScheme getFieldLayoutScheme() {
        if (this.fieldLayoutScheme == null) {
            this.fieldLayoutScheme = this.fieldLayoutManager.getMutableFieldLayoutScheme(this.getId());
        }
        return this.fieldLayoutScheme;
    }

    public Collection<IssueType> getAddableIssueTypes() {
        if (this.addableIssueTypes == null) {
            this.addableIssueTypes = new LinkedList<IssueType>(this.getAllRelevantIssueTypeObjects());
            Iterator<IssueType> iterator = this.addableIssueTypes.iterator();
            while (iterator.hasNext()) {
                IssueType issueType = iterator.next();
                if (this.getFieldLayoutScheme().getEntity(issueType.getId()) == null) continue;
                iterator.remove();
            }
        }
        return this.addableIssueTypes;
    }

    public Collection<EditableFieldLayout> getFieldLayouts() {
        if (this.editableFieldLayouts == null) {
            this.editableFieldLayouts = this.fieldLayoutManager.getEditableFieldLayouts();
        }
        return this.editableFieldLayouts;
    }

    public Long getFieldConfigurationId() {
        return this.fieldConfigurationId;
    }

    public void setFieldConfigurationId(Long fieldConfigurationId) {
        this.fieldConfigurationId = fieldConfigurationId;
    }

    public String getIssueTypeId() {
        return this.issueTypeId;
    }

    public void setIssueTypeId(String issueTypeId) {
        this.issueTypeId = issueTypeId;
    }

    public String getFieldLayoutId(EditableFieldLayout editableFieldLayout) {
        if (editableFieldLayout.getType() != null) {
            return "";
        }
        return editableFieldLayout.getId().toString();
    }

    @RequiresXsrfCheck
    public String doDeleteFieldLayoutSchemeEntity() {
        if (this.getIssueTypeId() == null) {
            this.addErrorMessage(this.getText("admin.errors.fieldlayoutscheme.cannot.delete.default"));
        }
        if (!this.invalidInput()) {
            Long unmappedLayoutId = this.getFieldLayoutScheme().getFieldLayoutId(null);
            Long layoutToRemoveId = this.getFieldLayoutScheme().getFieldLayoutId(this.getIssueTypeId());
            if (this.fieldLayoutSchemeHelper.doesChangingFieldLayoutAssociationRequireMessage(this.getLoggedInUser(), this.getFieldLayoutScheme(), layoutToRemoveId, unmappedLayoutId)) {
                this.reindexMessageManager.pushMessage(this.getLoggedInUser(), "admin.notifications.task.field.configuration");
            }
            this.getFieldLayoutScheme().removeEntity(this.getIssueTypeId());
            return this.getRedirect("ConfigureFieldLayoutScheme.jspa?id=" + this.getId());
        }
        return this.getResult();
    }

    public String doViewEditFieldLayoutSchemeEntity() {
        if (this.getId() == null) {
            this.addErrorMessage(this.getText("admin.errors.fieldlayoutscheme.no.issue.type"));
        }
        this.setFieldConfigurationId(this.getFieldLayoutScheme().getFieldLayoutId(this.getIssueTypeId()));
        return "input";
    }

    @RequiresXsrfCheck
    public String doEditFieldLayoutSchemeEntity() {
        if (this.getId() == null) {
            this.addErrorMessage(this.getText("admin.errors.fieldlayoutscheme.no.issue.type"));
        }
        FieldLayoutSchemeEntity fieldLayoutSchemeEntity = this.getFieldLayoutScheme().getEntity(this.getIssueTypeId());
        Long oldFieldLayoutId = fieldLayoutSchemeEntity.getFieldLayoutId();
        Long newFieldLayoutId = this.getFieldConfigurationId();
        fieldLayoutSchemeEntity.setFieldLayoutId(newFieldLayoutId);
        fieldLayoutSchemeEntity.store();
        if (this.fieldLayoutSchemeHelper.doesChangingFieldLayoutAssociationRequireMessage(this.getLoggedInUser(), this.getFieldLayoutScheme(), oldFieldLayoutId, newFieldLayoutId)) {
            this.reindexMessageManager.pushMessage(this.getLoggedInUser(), "admin.notifications.task.field.configuration");
        }
        return this.getRedirect("ConfigureFieldLayoutScheme.jspa?id=" + this.getId());
    }

    public String getEdited() {
        return this.edited;
    }

    public void setEdited(String edited) {
        this.edited = edited;
    }

    public IssueType getIssueType() {
        return this.constantsManager.getIssueType(this.getIssueTypeId());
    }

    public boolean isShouldDisplay(FieldLayoutSchemeEntity fieldLayoutSchemeEntity) {
        if (fieldLayoutSchemeEntity.getIssueTypeId() == null) {
            return true;
        }
        return this.getAllRelevantIssueTypes().contains(fieldLayoutSchemeEntity.getIssueTypeObject());
    }

    private Collection<IssueType> getAllRelevantIssueTypes() {
        if (this.allRelevantIssueTypes == null) {
            this.allRelevantIssueTypes = this.subTaskManager.isSubTasksEnabled() ? this.constantsManager.getAllIssueTypeObjects() : this.constantsManager.getRegularIssueTypeObjects();
        }
        return this.allRelevantIssueTypes;
    }

    private Collection<IssueType> getAllRelevantIssueTypeObjects() {
        if (this.allRelevantIssueTypeObjects == null) {
            this.allRelevantIssueTypeObjects = this.subTaskManager.isSubTasksEnabled() ? this.constantsManager.getAllIssueTypeObjects() : this.constantsManager.getRegularIssueTypeObjects();
        }
        return this.allRelevantIssueTypeObjects;
    }

    public List<Project> getUsedIn() {
        if (this.projects == null) {
            FieldLayoutScheme fieldLayoutScheme = this.getFieldLayoutScheme();
            this.projects = this.helper.getProjectsForScheme(fieldLayoutScheme == null ? null : fieldLayoutScheme.getId());
        }
        return this.projects;
    }
}

