/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuesecurity;

import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.issue.security.AssignIssueSecuritySchemeCommand;
import com.atlassian.jira.issue.security.AssignIssueSecuritySchemeTaskContext;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelManager;
import com.atlassian.jira.issue.security.IssueSecurityLevelScheme;
import com.atlassian.jira.issue.security.IssueSecuritySchemeManager;
import com.atlassian.jira.issue.security.IssueSecuritySchemeService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.scheme.AbstractSchemeAwareAction;
import com.atlassian.jira.scheme.SchemeManager;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.task.TaskContext;
import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.util.ParameterUtils;
import com.atlassian.jira.web.action.admin.notification.ProjectAware;
import com.atlassian.jira.web.bean.TaskDescriptorBean;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.ofbiz.core.entity.GenericEntityException;
import webwork.action.ActionContext;

@WebSudoRequired
public class SelectProjectSecuritySchemeStep2
extends AbstractSchemeAwareAction
implements ProjectAware {
    private Long origSchemeId;
    private Long newSchemeId;
    private Long projectId;
    private Project project;
    private Map<Long, Long> levels = null;
    private static final String LEVEL_PREFIX = "level_";
    private final TaskManager taskManager;
    private final TaskDescriptorBean.Factory taskBeanFactory;
    private final IssueSecuritySchemeManager issueSecuritySchemeManager;
    private final IssueSecuritySchemeService issueSecuritySchemeService;
    private final ProjectManager projectManager;
    private final IssueSecurityLevelManager issueSecurityLevelManager;
    private Long taskId;
    private TaskDescriptor<AssignIssueSecuritySchemeCommand.AssignSecurityLevelResult> currentTaskDescriptor;
    private TaskDescriptorBean<AssignIssueSecuritySchemeCommand.AssignSecurityLevelResult> currentTask;
    private String destinationURL;

    public SelectProjectSecuritySchemeStep2(TaskManager taskManager, TaskDescriptorBean.Factory taskBeanFactory, IssueSecuritySchemeManager issueSecuritySchemeManager, IssueSecuritySchemeService issueSecuritySchemeService, ProjectManager projectManager, IssueSecurityLevelManager issueSecurityLevelManager) {
        this.taskManager = taskManager;
        this.taskBeanFactory = taskBeanFactory;
        this.issueSecuritySchemeManager = issueSecuritySchemeManager;
        this.issueSecuritySchemeService = issueSecuritySchemeService;
        this.projectManager = projectManager;
        this.issueSecurityLevelManager = issueSecurityLevelManager;
    }

    public String doDefault() throws Exception {
        TaskDescriptor<AssignIssueSecuritySchemeCommand.AssignSecurityLevelResult> taskDescriptor = this.getCurrentTaskDescriptor();
        if (taskDescriptor != null) {
            return this.getRedirect(taskDescriptor.getProgressURL());
        }
        return super.doDefault();
    }

    protected void doValidation() {
        if (this.origSchemeId != null && this.origSchemeId.equals(this.newSchemeId)) {
            this.addErrorMessage(this.getText("admin.errors.project.already.associated"));
        }
    }

    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        this.setDestinationURL(StringUtils.isNotBlank((CharSequence)this.getReturnUrl()) ? this.getReturnUrl() : this.getDefaultDestinationURL());
        this.setReturnUrl(null);
        TaskDescriptor<AssignIssueSecuritySchemeCommand.AssignSecurityLevelResult> taskDescriptor = this.getCurrentTaskDescriptor();
        if (taskDescriptor != null) {
            return this.getRedirect(taskDescriptor.getProgressURL());
        }
        ServiceOutcome serviceOutcome = this.issueSecuritySchemeService.assignSchemeToProject(this.getLoggedInUser(), this.project.getId().longValue(), this.newSchemeId, this.getLevels());
        if (!serviceOutcome.isValid()) {
            this.addErrorMessages(serviceOutcome.getErrorCollection().getErrorMessages());
            this.addErrors(serviceOutcome.getErrorCollection().getErrors());
            return "error";
        }
        String redirectUrl = (String)serviceOutcome.get();
        return this.getRedirect(redirectUrl + "&destinationURL=" + this.getDestinationURL());
    }

    public String doProgress() throws ExecutionException, InterruptedException {
        if (this.taskId == null) {
            this.addErrorMessage(this.getText("admin.indexing.no.task.id"));
            return "error";
        }
        this.currentTaskDescriptor = this.taskManager.getTask(this.taskId);
        if (this.currentTaskDescriptor == null) {
            this.addErrorMessage(this.getText("admin.indexing.no.task.found"));
            return "error";
        }
        TaskContext context = this.currentTaskDescriptor.getTaskContext();
        if (!(context instanceof AssignIssueSecuritySchemeTaskContext)) {
            this.addErrorMessage(this.getText("common.tasks.wrong.task.context", AssignIssueSecuritySchemeTaskContext.class.getName(), context.getClass().getName()));
            return "error";
        }
        this.currentTask = this.taskBeanFactory.create(this.currentTaskDescriptor);
        if (this.currentTaskDescriptor.isFinished() && !this.currentTaskDescriptor.isCancelled()) {
            AssignIssueSecuritySchemeCommand.AssignSecurityLevelResult result = this.currentTaskDescriptor.getResult();
            this.addErrorCollection(result.getErrorCollection());
        }
        return "progress";
    }

    private Map<Long, Long> getLevels() {
        if (this.levels == null) {
            this.levels = new HashMap<Long, Long>();
            Map parameters = ActionContext.getParameters();
            Set keys = parameters.keySet();
            for (Object key1 : keys) {
                Long longParam;
                String key = (String)key1;
                if (!key.startsWith(LEVEL_PREFIX) || (longParam = ParameterUtils.getLongParam((Map)parameters, (String)key)) == null) continue;
                this.levels.put(new Long(key.substring(LEVEL_PREFIX.length())), longParam);
            }
        }
        return this.levels;
    }

    public long getAffectedIssues(Long levelId) {
        Long realLevelId = null;
        if (levelId != null && levelId != -1L) {
            realLevelId = levelId;
        }
        return this.issueSecurityLevelManager.getIssueCount(realLevelId, this.projectId);
    }

    public long getTotalAffectedIssues() {
        long affectedIssues = 0L;
        try {
            for (IssueSecurityLevel level : this.getOriginalSecurityLevels()) {
                affectedIssues += this.getAffectedIssues(level.getId());
            }
        }
        catch (Exception e) {
            this.addErrorMessage(this.getText("admin.errors.exception") + " " + e);
        }
        return affectedIssues;
    }

    public List<IssueSecurityLevel> getOriginalSecurityLevels() {
        return this.getSecurityLevels(this.origSchemeId);
    }

    public List<IssueSecurityLevel> getNewSecurityLevels() {
        return this.getSecurityLevels(this.newSchemeId);
    }

    private ImmutableList<IssueSecurityLevel> getSecurityLevels(Long schemeId) {
        if (schemeId == null) {
            return ImmutableList.of();
        }
        return ImmutableList.builder().add((Object)this.getNullIssueSecurityLevel(schemeId)).addAll((Iterable)this.issueSecurityLevelManager.getIssueSecurityLevels(schemeId.longValue())).build();
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public Long getOrigSchemeId() {
        return this.origSchemeId;
    }

    public void setOrigSchemeId(Long origSchemeId) {
        this.origSchemeId = origSchemeId == null || origSchemeId.equals(new Long(-1L)) ? null : origSchemeId;
    }

    public Long getNewSchemeId() {
        return this.newSchemeId;
    }

    public void setNewSchemeId(Long newSchemeId) {
        this.newSchemeId = newSchemeId == null || newSchemeId.equals(new Long(-1L)) ? null : newSchemeId;
    }

    @Override
    public Long getProjectId() {
        return this.projectId;
    }

    @Override
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    @Override
    public Project getProject() {
        if (this.project == null) {
            this.project = this.projectManager.getProjectObj(this.getProjectId());
        }
        return this.project;
    }

    @Override
    public SchemeManager getSchemeManager() {
        return this.issueSecuritySchemeManager;
    }

    @Override
    public String getRedirectURL() throws GenericEntityException {
        return "/plugins/servlet/project-config/" + this.getProject().getKey() + "/issuesecurity";
    }

    public IssueSecurityLevelScheme getSecurityScheme(Long schemeId) throws GenericEntityException {
        return this.issueSecuritySchemeManager.getIssueSecurityLevelScheme(schemeId);
    }

    public static String getLevelPrefix() {
        return LEVEL_PREFIX;
    }

    public String getDestinationURL() {
        return this.destinationURL;
    }

    public void setDestinationURL(String destinationURL) {
        this.destinationURL = destinationURL;
    }

    public TaskDescriptorBean<AssignIssueSecuritySchemeCommand.AssignSecurityLevelResult> getCurrentTask() {
        TaskDescriptor<AssignIssueSecuritySchemeCommand.AssignSecurityLevelResult> taskDescriptor;
        if (this.currentTask == null && (taskDescriptor = this.getCurrentTaskDescriptor()) != null) {
            this.currentTask = this.taskBeanFactory.create(taskDescriptor);
        }
        return this.currentTask;
    }

    private TaskDescriptor<AssignIssueSecuritySchemeCommand.AssignSecurityLevelResult> getCurrentTaskDescriptor() {
        if (this.currentTaskDescriptor == null) {
            this.currentTaskDescriptor = this.taskManager.getLiveTask(new AssignIssueSecuritySchemeTaskContext(this.getProject()));
        }
        return this.currentTaskDescriptor;
    }

    public String getDefaultDestinationURL() {
        Project project = this.getProject();
        if (project != null) {
            return "/plugins/servlet/project-config/" + project.getKey() + "/issuesecurity";
        }
        return "/secure/project/ViewProjects.jspa";
    }

    private IssueSecurityLevel getNullIssueSecurityLevel(final Long schemeId) {
        return new IssueSecurityLevel(){

            public Long getId() {
                return -1L;
            }

            public String getName() {
                return SelectProjectSecuritySchemeStep2.this.getI18nHelper().getText("common.words.none");
            }

            public String getDescription() {
                return SelectProjectSecuritySchemeStep2.this.getI18nHelper().getText("common.words.none");
            }

            public Long getSchemeId() {
                return schemeId;
            }
        };
    }
}

