/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.issuetypes;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.bulkedit.operation.BulkMoveOperation;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.IssueTypeSchemeService;
import com.atlassian.jira.entity.WithFunctions;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.issue.archiving.ArchivedIssueSearchService;
import com.atlassian.jira.issue.fields.FieldManager;
import com.atlassian.jira.issue.fields.config.FieldConfigPredicate;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.issue.fields.config.manager.IssueTypeSchemeManager;
import com.atlassian.jira.issue.fields.option.Option;
import com.atlassian.jira.issue.fields.option.OptionSetManager;
import com.atlassian.jira.issue.issuetype.IssueType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.util.ComponentFactory;
import com.atlassian.jira.web.action.admin.issuetypes.ConfigureOptionScheme;
import com.atlassian.jira.web.action.admin.issuetypes.IssueTypeManageableOption;
import com.atlassian.jira.web.action.admin.issuetypes.ProjectIssueTypeSchemeHelper;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;

@WebSudoRequired
public class ConfigureIssueTypeOptionScheme
extends ConfigureOptionScheme {
    private final ComponentFactory componentFactory;
    private final ArchivedIssueSearchService archivedIssueSearchService;
    private List<Project> associatedProjects;

    public ConfigureIssueTypeOptionScheme(FieldConfigSchemeManager configSchemeManager, IssueTypeSchemeManager issueTypeSchemeManager, FieldManager fieldManager, OptionSetManager optionSetManager, IssueTypeManageableOption manageableOptionType, BulkMoveOperation bulkMoveOperation, ConstantsManager constantsManager, IssueManager issueManager, ComponentFactory factory, EventPublisher eventPublisher, IssueTypeSchemeService issueTypeSchemeService, ArchivedIssueSearchService archivedIssueSearchService) {
        super(configSchemeManager, issueTypeSchemeManager, fieldManager, optionSetManager, manageableOptionType, bulkMoveOperation, constantsManager, issueManager, eventPublisher, issueTypeSchemeService);
        this.componentFactory = factory;
        this.archivedIssueSearchService = archivedIssueSearchService;
    }

    @Override
    protected void doValidation() {
        super.doValidation();
        if (CollectionUtils.exists((Collection)this.issueTypeSchemeManager.getAllSchemes(), (Predicate)new FieldConfigPredicate(this.getSchemeId(), this.getName()))) {
            this.addError("name", this.getText("admin.errors.issuetypes.duplicate.name"));
        }
        if (this.getSelectedOptions() != null && this.getSelectedOptions().length > 0) {
            boolean hasNormalIssueType = false;
            for (int i = 0; i < this.getSelectedOptions().length; ++i) {
                String id = this.getSelectedOptions()[i];
                IssueType issueType = this.constantsManager.getIssueTypeObject(id);
                if (issueType.isSubTask()) continue;
                hasNormalIssueType = true;
                break;
            }
            if (!hasNormalIssueType) {
                this.addErrorMessage(this.getText("admin.errors.issuetypes.must.select.standard.issue.type"));
            }
        }
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        List associatedProjects = this.getConfigScheme().getAssociatedProjectObjects();
        if (associatedProjects != null && !associatedProjects.isEmpty()) {
            ArrayList projectIds = Lists.newArrayList((Iterable)WithFunctions.getIds((Collection)associatedProjects));
            Collection obseleteOptions = CollectionUtils.subtract(this.getOriginalOptions(), this.getNewOptions());
            if (obseleteOptions != null && !obseleteOptions.isEmpty()) {
                ArrayList<String> obseleteOptionIds = new ArrayList<String>(obseleteOptions.size());
                for (Option option : obseleteOptions) {
                    obseleteOptionIds.add(option.getId());
                }
                ArrayList<Issue> affectedIssues = new ArrayList<Issue>(this.issueTypeSchemeService.getIssuesMatchingTypesInProjects(this.getLoggedInUser(), (Collection)projectIds, obseleteOptionIds));
                affectedIssues.addAll(this.archivedIssueSearchService.getArchivedIssuesMatchingTypesInProjects(projectIds, obseleteOptionIds));
                if (affectedIssues != null && !affectedIssues.isEmpty()) {
                    this.configScheme = new FieldConfigScheme.Builder(this.getConfigScheme()).setName(this.getName()).setDescription(this.getDescription()).toFieldConfigScheme();
                    ArrayList<String> optionIds = new ArrayList<String>(Arrays.asList(this.getSelectedOptions()));
                    return this.migrateIssues(this, affectedIssues, optionIds);
                }
            }
        }
        return super.doExecute();
    }

    public List<Project> getUsedIn() {
        if (this.associatedProjects == null) {
            ProjectIssueTypeSchemeHelper helper = this.componentFactory.createObject(ProjectIssueTypeSchemeHelper.class, new Object[0]);
            this.associatedProjects = helper.getProjectsUsingScheme(this.getConfigScheme());
        }
        return this.associatedProjects;
    }

    @Override
    public boolean isAllowEditOptions() {
        return !this.issueTypeSchemeManager.getDefaultIssueTypeScheme().getId().equals(this.getSchemeId());
    }
}

