/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.priorities;

import com.atlassian.collectors.CollectorsUtil;
import com.atlassian.jira.issue.fields.config.FieldConfig;
import com.atlassian.jira.issue.fields.config.FieldConfigScheme;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.issue.priority.Priority;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class AbstractPrioritySchemesAction
extends JiraWebActionSupport {
    private final PrioritySchemeManager prioritySchemeManager;
    private Long actionedSchemeId;
    private List<FieldConfigScheme> prioritySchemes;

    protected AbstractPrioritySchemesAction(PrioritySchemeManager prioritySchemeManager) {
        this.prioritySchemeManager = prioritySchemeManager;
    }

    public Long getActionedSchemeId() {
        return this.actionedSchemeId;
    }

    public void setActionedSchemeId(Long actionedSchemeId) {
        this.actionedSchemeId = actionedSchemeId;
    }

    public List<FieldConfigScheme> getPrioritySchemes() {
        if (this.prioritySchemes == null) {
            this.prioritySchemes = this.getPrioritySchemeManager().getAllSchemes();
        }
        return this.prioritySchemes;
    }

    private ImmutableList<Priority> getPrioritiesForScheme(FieldConfigScheme configScheme) {
        FieldConfig config = this.getPrioritySchemeManager().getFieldConfigForDefaultMapping(configScheme);
        return (ImmutableList)this.getPrioritySchemeManager().getOptions(config).stream().map(id -> this.getConstantsManager().getPriorityObject(id)).collect(CollectorsUtil.toImmutableList());
    }

    protected Map<String, ImmutableList<Priority>> getPriorities() {
        return this.getPrioritySchemes().stream().collect(Collectors.toMap(scheme -> scheme.getId().toString(), this::getPrioritiesForScheme));
    }

    protected Long getDefaultPrioritySchemeId() {
        FieldConfigScheme defaultScheme = this.getPrioritySchemeManager().getDefaultScheme();
        return Optional.ofNullable(defaultScheme).map(FieldConfigScheme::getId).orElse(null);
    }

    protected Map<String, String> getDefaultPrioritiesIds() {
        List<FieldConfigScheme> prioritySchemes = this.getPrioritySchemes();
        HashMap<String, String> schemeIdToDefaultPriority = new HashMap<String, String>(prioritySchemes.size());
        for (FieldConfigScheme priorityScheme : prioritySchemes) {
            String defaultValue = this.getPrioritySchemeManager().getDefaultOption(this.getPrioritySchemeManager().getFieldConfigForDefaultMapping(priorityScheme));
            if (defaultValue == null) continue;
            schemeIdToDefaultPriority.put(priorityScheme.getId().toString(), defaultValue);
        }
        return schemeIdToDefaultPriority;
    }

    protected PrioritySchemeManager getPrioritySchemeManager() {
        return this.prioritySchemeManager;
    }

    protected String redirectToView() {
        return this.returnCompleteWithInlineRedirect("ViewPrioritySchemes.jspa");
    }
}

