/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.priorities;

import com.atlassian.jira.task.TaskDescriptor;
import com.atlassian.jira.task.TaskManager;
import com.atlassian.jira.task.TaskProgressEvent;
import com.atlassian.jira.web.action.ActionViewData;
import com.atlassian.jira.web.action.JiraWebActionSupport;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

@WebSudoRequired
public class MigratePrioritySchemeProgress
extends JiraWebActionSupport {
    private final PageBuilderService pageBuilder;
    private final TaskManager taskManager;
    private long updatedCount = 0L;
    private List<Long> projects = ImmutableList.of();
    private Long targetSchemeId;
    private Long taskId;
    private int progressPerCent = 0;
    private boolean finished = false;
    private String lastProgressMessage = "";

    public MigratePrioritySchemeProgress(PageBuilderService pageBuilder, TaskManager taskManager) {
        this.pageBuilder = pageBuilder;
        this.taskManager = taskManager;
    }

    public String doDefault() {
        this.pageBuilder.assembler().resources().requireWebResource("jira.webresources:migrate-priority-scheme");
        TaskDescriptor task = this.taskManager.getTask(this.taskId);
        if (task == null) {
            this.addErrorMessage(this.getText("common.tasks.task.not.found"));
            return "error";
        }
        this.progressPerCent = MigratePrioritySchemeProgress.taskPercentage(task);
        this.lastProgressMessage = MigratePrioritySchemeProgress.taskLastMessage(task);
        if (task.isFinished()) {
            this.updatedCount = (Long)task.getResult();
            this.finished = true;
        } else {
            this.finished = false;
        }
        return "success";
    }

    private static int taskPercentage(TaskDescriptor<?> task) {
        TaskProgressEvent lastEvent;
        TaskProgressEvent taskProgressEvent = lastEvent = task.getTaskProgressIndicator() != null ? task.getTaskProgressIndicator().getLastProgressEvent() : null;
        if (lastEvent != null) {
            if (lastEvent.getTaskProgress() < 0L) {
                return 0;
            }
            if (lastEvent.getTaskProgress() > 100L) {
                return 100;
            }
            return (int)lastEvent.getTaskProgress();
        }
        return 0;
    }

    private static String taskLastMessage(TaskDescriptor<?> task) {
        TaskProgressEvent lastEvent;
        TaskProgressEvent taskProgressEvent = lastEvent = task.getTaskProgressIndicator() != null ? task.getTaskProgressIndicator().getLastProgressEvent() : null;
        if (lastEvent != null) {
            return (String)StringUtils.defaultIfBlank((CharSequence)lastEvent.getCurrentSubTask(), (CharSequence)"");
        }
        return "";
    }

    @ActionViewData(key="updatedCount")
    public long getUpdatedCount() {
        return this.updatedCount;
    }

    @ActionViewData(key="projectId")
    public Long[] getProjectId() {
        return this.projects.toArray(new Long[0]);
    }

    public void setProjectId(Long[] projectId) {
        this.projects = ImmutableList.copyOf((Object[])projectId);
    }

    public Long getTargetSchemeId() {
        return this.targetSchemeId;
    }

    public void setTargetSchemeId(Long targetSchemeId) {
        this.targetSchemeId = targetSchemeId;
    }

    @ActionViewData(key="taskId")
    public Long getTaskId() {
        return this.taskId;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    @ActionViewData(key="progressPerCent")
    public int getProgressPerCent() {
        return this.progressPerCent;
    }

    @ActionViewData(key="lastProgressMessage")
    public String getLastProgressMessage() {
        return this.lastProgressMessage;
    }

    @ActionViewData(key="xsrfToken")
    public String getToken() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.getXsrfToken(), (CharSequence)"");
    }

    @ActionViewData(key="finished")
    public boolean isFinished() {
        return this.finished;
    }

    @ActionViewData(key="errorMessages")
    public Collection<String> getErrorMessages() {
        return super.getErrorMessages();
    }
}

