/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.web.action.admin.resolutions;

import com.atlassian.jira.config.ResolutionManager;
import com.atlassian.jira.issue.resolution.Resolution;
import com.atlassian.jira.security.xsrf.RequiresXsrfCheck;
import com.atlassian.jira.web.action.admin.constants.AbstractDeleteConstant;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.util.Collection;

@WebSudoRequired
public class DeleteResolution
extends AbstractDeleteConstant<Resolution> {
    private final ResolutionManager resolutionManager;

    public DeleteResolution(ResolutionManager resolutionManager) {
        this.resolutionManager = resolutionManager;
    }

    @Override
    protected String getConstantEntityName() {
        return "Resolution";
    }

    @Override
    protected String getNiceConstantName() {
        return this.getText("admin.issue.constant.resolution.lowercase");
    }

    @Override
    protected String getIssueConstantField() {
        return "resolution";
    }

    @Override
    protected Resolution getConstant(String id) {
        return this.getConstantsManager().getResolutionObject(id);
    }

    @Override
    protected String getRedirectPage() {
        return "ViewResolutions.jspa";
    }

    @Override
    protected Collection<Resolution> getConstants() {
        return this.getConstantsManager().getResolutionObjects();
    }

    @Override
    protected void clearCaches() {
        this.getConstantsManager().refreshResolutions();
    }

    @Override
    @RequiresXsrfCheck
    protected String doExecute() throws Exception {
        if (this.confirm) {
            this.resolutionManager.removeResolution(this.id, this.newId);
        }
        if (this.getHasErrorMessages()) {
            return "error";
        }
        return this.getRedirect(this.getRedirectPage());
    }
}

